PROGRAM TP6_F

  USE iso_c_binding
  USE omp_lib
  IMPLICIT NONE

  include "f90papi.h"

  INTEGER, PARAMETER :: N = 1000000
  INTEGER, PARAMETER :: N_ITER = 10000
  INTEGER, PARAMETER :: NUM_EVENTS = 3
  INTEGER, PARAMETER :: MAX_THREADS = 32

  INTEGER, PARAMETER :: CACHE_LINE_SIZE = 64
  INTEGER, PARAMETER :: ALIGN = (CACHE_LINE_SIZE / 2)


  INTEGER(C_INT) :: nb_hwc, retval
  INTEGER(C_INT), DIMENSION(NUM_EVENTS) :: events = (/ PAPI_TOT_INS, PAPI_TOT_CYC, PAPI_NULL /)
  INTEGER(C_LONG_LONG), DIMENSION(NUM_EVENTS) :: values
  CHARACTER(LEN=PAPI_MAX_STR_LEN) :: event_name
  INTEGER :: my_thread_num, nn, my_idx

  REAL, DIMENSION(N) :: x, y
  REAL :: sum
  REAL, DIMENSION(MAX_THREADS*ALIGN) :: sum_local


  INTEGER :: i, j

  retval = PAPI_VER_CURRENT
  CALL PAPIF_library_init(retval)
  IF (retval.NE.PAPI_VER_CURRENT) THEN
    WRITE(6,*) "This program was compiled for another PAPI version"
    STOP
  END IF

  CALL PAPIF_thread_init(omp_get_thread_num, retval);
  IF (retval.lt.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_thread_init')
    STOP
  END IF

  CALL PAPIF_num_counters(nb_hwc)
  IF (nb_hwc.lt.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_num_counters')
    STOP
  END IF

  WRITE(6, '(I0,A)') nb_hwc, " available hardware counter(s)."

  x = 1.0
  y = 2.0

  CALL PAPIF_event_name_to_code('MEM_UNCORE_RETIRED:LOCAL_HITM', events(3), retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_event_name_to_code')
    STOP
  END IF

!$OMP PARALLEL PRIVATE(retval)
  CALL PAPIF_start_counters(events, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_start_counters')
    STOP
  END IF
!$OMP END PARALLEL

!$OMP PARALLEL PRIVATE(my_thread_num, nn)
  my_thread_num = omp_get_thread_num()
  my_idx = my_thread_num * ALIGN + 1;

  sum_local(my_idx) = 0.0

!$OMP DO private(i)
  DO j = 1, N_ITER
    DO i = 1, N
      sum_local(my_idx) = sum_local(my_idx) + x(i) * y(i);
    END DO 
  END DO  
!$OMP END DO

!$OMP ATOMIC
    sum = sum + sum_local(my_idx);

!$OMP END PARALLEL

!$OMP PARALLEL PRIVATE(retval, values, my_thread_num, i, event_name)
  my_thread_num = omp_get_thread_num()

  CALL PAPIF_stop_counters(values, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_stop_counters')
    STOP
  END IF

!$OMP CRITICAL
  DO i = 1, NUM_EVENTS
    CALL PAPIF_event_code_to_name(events(i), event_name, retval)
    WRITE(6, '(A,I0,A,A,A,I0)') "Thread ",my_thread_num,":",TRIM(event_name), ": ", values(i)
  END DO
  WRITE(6, '(A,F4.2)') 'CPI: ', REAL(values(2)) / REAL(values(1))
!$OMP END CRITICAL
!$OMP END PARALLEL

END PROGRAM TP6_F
