PROGRAM TP4_F

  USE iso_c_binding
  IMPLICIT NONE

  include "f90papi.h"

  INTEGER, PARAMETER :: N = 4096
  INTEGER, PARAMETER :: NUM_EVENTS = 4

  INTEGER(C_INT) :: nb_hwc, retval
  INTEGER(C_INT), DIMENSION(NUM_EVENTS) :: events = (/ PAPI_L1_TCM, PAPI_L2_TCM, PAPI_L3_TCM, PAPI_TOT_INS /)
  INTEGER(C_LONG_LONG), DIMENSION(NUM_EVENTS) :: values
  CHARACTER(LEN=PAPI_MAX_STR_LEN) :: event_name

  REAL, DIMENSION(N, N) :: a, b

  INTEGER :: i

  CALL PAPIF_num_counters(nb_hwc)

  IF (nb_hwc.lt.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_num_counters')
    STOP
  END IF

  WRITE(6, '(I0,A)') nb_hwc, " available hardware counter(s)."

  a = 1.0

  CALL PAPIF_start_counters(events, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_start_counters')
    STOP
  END IF

  CALL matcpy(a, b, n);

  CALL PAPIF_stop_counters(values, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_stop_counters')
    STOP
  END IF

  DO i = 1, NUM_EVENTS
    CALL PAPIF_event_code_to_name(events(i), event_name, retval)
    WRITE(6, '(A,A,I0)') TRIM(event_name), ": ", values(i)
  END DO

END PROGRAM TP4_F

SUBROUTINE matcpy(src, dst, n)
  IMPLICIT NONE

  INTEGER, INTENT(IN) :: n
  REAL, DIMENSION(n, n), INTENT(IN) :: src
  REAL, DIMENSION(n, n), INTENT(OUT) :: dst

  INTEGER :: i, j

  DO i = 1, n
    DO j = 1, n
      dst(i, j) = src(i, j)
    END DO
  END DO

END SUBROUTINE matcpy
