#include <stdio.h>
#include <stdlib.h>
#include <papi.h>

#define N 4096

#define NUM_EVENTS 4

static void matcpy(float src[][N], float dst[][N])
{
    int i, j;

    for (j = 0; j < N; j++) {
        for (i = 0; i < N; i++) {
            src[i][j] = dst[i][j];
        }
    }
}

int main(int argc, char *argv[])
{
    int i, j, nb_hwc, retval;
    float a[N][N], b[N][N];
    int events[NUM_EVENTS] = {PAPI_L1_TCM, PAPI_L2_TCM, PAPI_L3_TCM, PAPI_TOT_INS};
    char event_name[PAPI_MAX_STR_LEN];
    long_long values[NUM_EVENTS];

    nb_hwc = PAPI_num_counters();
    if (nb_hwc < PAPI_OK) {
        PAPI_perror("PAPI_num_counters");
        return 1;
    }

    printf("%d available hardware counter(s).\n", nb_hwc);

    for (j = 0; j < N; ++j) {
        for (i = 0; i < N; ++i) {
            a[j][i] = 1.0;
        }
    }

    retval = PAPI_start_counters(events, NUM_EVENTS);
    if (retval != PAPI_OK) {
        PAPI_perror("PAPI_start_counters");
        return 1;
    }

    matcpy(a, b);

    retval = PAPI_stop_counters(values, NUM_EVENTS);
    if (retval != PAPI_OK) {
        PAPI_perror("PAPI_stop_counters");
        return 1;
    }

    for (i = 0; i < NUM_EVENTS; i++) {
        PAPI_event_code_to_name(events[i], event_name);
        printf("%s: %lld\n", event_name, values[i]);
    }

    return 0;
}
