PROGRAM TP3_F

  USE iso_c_binding
  IMPLICIT NONE

  include "f90papi.h"

  INTEGER, PARAMETER :: N = 1000000
  INTEGER, PARAMETER :: N_ITER = 10000
  INTEGER, PARAMETER :: NUM_EVENTS = 2

  INTEGER(C_INT) :: nb_hwc, retval
  INTEGER(C_INT), DIMENSION(NUM_EVENTS) :: events = (/ PAPI_FP_OPS, PAPI_TOT_CYC/)
  INTEGER(C_LONG_LONG), DIMENSION(NUM_EVENTS) :: values
  CHARACTER(LEN=PAPI_MAX_STR_LEN) :: event_name
  INTEGER(C_LONG_LONG) :: start_usec, end_usec
  REAL(KIND=8) :: elapse

  REAL, DIMENSION(N) :: x, y

  INTEGER :: i

  CALL PAPIF_num_counters(nb_hwc)

  IF (nb_hwc.lt.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_num_counters')
    STOP
  END IF

  WRITE(6, '(I0,A)') nb_hwc, " available hardware counter(s)."

  x = 1.0
  y = 2.0

  CALL PAPIF_start_counters(events, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_start_counters')
    STOP
  END IF

  CALL PAPIF_get_real_usec(start_usec)
  DO i = 1, N_ITER
    CALL saxpy(3.0, x, y, N);
  END DO
  CALL PAPIF_get_real_usec(end_usec)

  CALL PAPIF_stop_counters(values, NUM_EVENTS, retval)
  IF (retval.ne.PAPI_OK) THEN
    CALL PAPIF_perror('PAPIF_stop_counters')
    STOP
  END IF

  DO i = 1, NUM_EVENTS
    CALL PAPIF_event_code_to_name(events(i), event_name, retval)
    WRITE(6, '(A,A,I0)') TRIM(event_name), ": ", values(i)
  END DO

  elapse = REAL(end_usec - start_usec, 8) / 1000000.0
  WRITE(6, '(A,F5.2,A)') "Wall clock-time = ", elapse, "s"
  WRITE(6, '(A,F8.2)') "MFLOPS = ", REAL(values(1), 8) / (elapse * 1000000)

END PROGRAM TP3_F

SUBROUTINE saxpy(a, x, y, n)
  IMPLICIT NONE

  REAL, INTENT(IN) :: a
  INTEGER, INTENT(IN) :: n
  REAL, DIMENSION(n), INTENT(IN) :: x
  REAL, DIMENSION(n), INTENT(INOUT) :: y

  INTEGER :: i

  DO i = 1, n
    y(i) = a * x(i) + y(i)
  END DO

END SUBROUTINE saxpy
