#include <stdio.h>
#include <papi.h>

#define N 1000000
#define N_ITER 10000

#define NUM_EVENTS 2

void saxpy(float a, float *x, float *y, int n)
{
    int i;

    for (i = 0; i < n; i++) {
        y[i] = a * x[i] + y[i];
    }
}

int main(int argc, char *argv[])
{
    int i, nb_hwc, retval;
    float x[N], y[N];
    int events[NUM_EVENTS] = {PAPI_FP_OPS, PAPI_TOT_CYC};
    char event_name[PAPI_MAX_STR_LEN];
    long_long values[NUM_EVENTS];
    long_long start_usec, end_usec;
    double elapse;

    nb_hwc = PAPI_num_counters();
    if (nb_hwc < PAPI_OK) {
        PAPI_perror("PAPI_num_counters");
        return 1;
    }

    printf("%d available hardware counter(s).\n", nb_hwc);

    for (i = 0; i < N; i++) {
        x[i] = 1.0;
        y[i] = 2.0;
    }

    retval = PAPI_start_counters(events, NUM_EVENTS);
    if (retval != PAPI_OK) {
        PAPI_perror("PAPI_start_counters");
        return 1;
    }

    start_usec = PAPI_get_real_usec();
    for (i = 0; i < N_ITER; i++) {
        saxpy(3.0, x, y, N);
    }
    end_usec = PAPI_get_real_usec();

    retval = PAPI_stop_counters(values, NUM_EVENTS);
    if (retval != PAPI_OK) {
        PAPI_perror("PAPI_stop_counters");
        return 1;
    }

    for (i = 0; i < NUM_EVENTS; i++) {
        PAPI_event_code_to_name(events[i], event_name);
        printf("%s: %lld\n", event_name, values[i]);
    }
    elapse = ((double) (end_usec - start_usec)) / 1000000.0;
    printf("Wall clock-time = %.2fs\n", elapse);

    printf("MFLOPS = %8.2f\n", ((double) values[0]) / (elapse * 1000000));

    return 0;
}
