#include <stdio.h>
#include <omp.h>
#include <math.h>
#define CHUNK 5
#define N     40

main ()  
{
  int i, n, chunk, tid;
  float a[N], b[N], c[N];

  /* Some initializations */
  for (i=0; i < N; i++)
  {
    a[i] = b[i] = i * 1.0;
  }
  n = N;
  chunk = CHUNK;

  #pragma omp parallel shared(a,b,c,n,chunk) private(i,tid)
  {
    tid = omp_get_thread_num();
    printf("Hello World from thread = %d\n", tid);

    #pragma omp for schedule(dynamic,chunk) nowait
    for (i=0; i < n; i++)
    {
      c[i] = sqrt(a[i]) + cos(b[i]);
      printf("thread = %d loop %d\n", tid, i);
    }

  }  /* end of parallel section */

}
