#include <stdio.h>
#include <omp.h>
#define N 10
#define CHUNK 2

main ()  
{
  int   i, n, chunk, tid;
  float a[N], b[N], result;
  int nthreads;

  /* Some initializations */
  n = N;
  chunk = CHUNK;

  result = 0.0;

  for (i=0; i < n; i++)
  {
    a[i] = i * 1.0;
    b[i] =  1.0;
  }

  #pragma omp parallel default(shared) private(i,tid) 
  {
    nthreads = omp_get_num_threads();
    tid = omp_get_thread_num();
    printf("tid= %d out of %d\n", tid, nthreads);

    #pragma omp for schedule(static,chunk) reduction(+:result)
    for (i=0; i < n; i++)
    {
      result = result + (a[i] * b[i]);
      printf("thread = %d loop %03d result %f\n", tid, i, result);
    }

  }

  printf("Final result= %f\n",result);
}
