update_distance_matrix <- function(distance.matrix, imin, jmin) {
  n <- dim(distance.matrix)[1]
  newline <- sapply(1:n, FUN = function(k) {
    return(max(distance.matrix[imin, k], distance.matrix[jmin, k]))
  })       
  distance.matrix[imin, ] <- newline
  distance.matrix[, imin] <- newline
  distance.matrix[imin, imin] <- 0
  return(distance.matrix)
}

update_clusters <- function(clusters, imin, jmin) {
  n <- length(clusters)
  clusters[[imin]] <- c(clusters[[imin]], clusters[[jmin]])
  clusters[[jmin]] <- clusters[[n]]
  clusters[[n]] <- NULL
  return(clusters)
}

resize_distance_matrix <- function(distance.matrix, jmin) {
  n <- dim(distance.matrix)[1]
  distance.matrix[jmin, ] <- distance.matrix[n, ]
  distance.matrix[, jmin] <- distance.matrix[, n]
  distance.matrix[jmin,jmin] <- 0
  return(distance.matrix[1:(n - 1), 1:(n - 1)])
}
