/*

Copyright 2011-2012 by

Laboratoire d'Informatique de Paris 6, equipe PEQUAN,
UPMC Universite Paris 06 - CNRS - UMR 7606 - LIP6, Paris, France,

Contributor Ch. Lauter

christoph.lauter@ens-lyon.org
sylvain.chevillard@ens-lyon.org

This software is a computer program whose purpose is to provide an
environment for safe floating-point code development. It is
particularily targeted to the automatized implementation of
mathematical floating-point libraries (libm). Amongst other features,
it offers a certified infinity norm, an automatic polynomial
implementer and a fast Remez algorithm.

This software is governed by the CeCILL-C license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL-C
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-C license and that you accept its terms.

This program is distributed WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

#ifndef SOLLYA_MESSAGING_H
#define SOLLYA_MESSAGING_H

/* Symbolic constants for the different messages

   THE ACTUAL #defines ARE FACTORED OUT IN sollya-messages.h
   IN ORDER TO ALLOW THE LIBRARY INCLUDE HEADER sollya.h TO USE THEM.

   TO ADD A MESSAGE, ADD A #define AT THE END OF THE LIST IN
   sollya-messages.h. THEN ADD A CORRESPONDING MESSAGE TEXT IN THE
   TABLE BELOW. 

   ATTENTION: THE MESSAGE NUMBERS MUST NOT BE NEGATIVE!

   DO NOT CHANGE THE #include THAT FOLLOWS.
*/
#include "sollya-messages.h"

/* A typedef for the Sollya message type */
struct __sollya_internal_type_msg_struct {
  int msg_id;
};
typedef struct __sollya_internal_type_msg_struct * sollya_msg_t;
typedef struct __sollya_internal_type_msg_struct sollya_msg_decl_t;

/* A table with textual explanations of the messages

   ADD A MESSAGE TEXT HERE ONCE YOU ADD A MESSAGE NUMBER IN
   sollya-messages.h

   The table gets defined only when sollya-messaging is included from
   sollya-messaging.c

   The table entries do not have to be sorted in any way. Just the
   last entry must have a negative (inexisting) message number. All
   other message numbers (used through their symbolic constants) must
   be positive.

*/
#if (defined(SOLLYA_MESSAGING_USE_TABLES) && (SOLLYA_MESSAGING_USE_TABLES))
typedef struct messageEntryStruct messageEntry;
struct messageEntryStruct {
  int msgNum;
  char *msgText;
};

static const messageEntry messageTextsTable[] = {
  { SOLLYA_MSG_CONTINUATION                                           , "Continuation of the last message that just has started" },
  { SOLLYA_MSG_UNDEFINED_ERROR                                        , "Some undefined error occurred. This is a place-holder" },
  { SOLLYA_MSG_ABS_NOT_TWICE_DIFFERENTIABLE                           , "abs is not twice differentiable" },
  { SOLLYA_MSG_HALF_NOT_DIFFERENTIABLE                                , "half-precision rounding operator not differentiable" },
  { SOLLYA_MSG_SINGLE_NOT_DIFFERENTIABLE                              , "single rounding operator not differentiable" },
  { SOLLYA_MSG_DOUBLE_NOT_DIFFERENTIABLE                              , "double rounding operator not differentiable" },
  { SOLLYA_MSG_DOUBLEEXTENDED_NOT_DIFFERENTIABLE                      , "double-extended rounding operator not differentiable" },
  { SOLLYA_MSG_DOUBLE_DOUBLE_NOT_DIFFERENTIABLE                       , "double-double rounding operator not differentiable" },
  { SOLLYA_MSG_TRIPLE_DOUBLE_NOT_DIFFERENTIABLE                       , "triple-double rounding operator not differentiable" },
  { SOLLYA_MSG_QUAD_NOT_DIFFERENTIABLE                                , "quad rounding operator not differentiable" },
  { SOLLYA_MSG_CEIL_NOT_DIFFERENTIABLE                                , "ceil operator not differentiable" },
  { SOLLYA_MSG_FLOOR_NOT_DIFFERENTIABLE                               , "floor operator not differentiable" },
  { SOLLYA_MSG_NEARESTINT_NOT_DIFFERENTIABLE                          , "nearestint operator not differentiable" },
  { SOLLYA_MSG_UNDESIRED_ROUNDING_IN_ROUND_TO_FORMAT                  , "An undesired rounding occurred in round to format" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_TO_DOUBLE                     , "A double rounding occurred in round to double" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_TO_PREC                       , "A double rounding occurred in round-to-prec" },
  { SOLLYA_MSG_ROUNDING_OCCURRED_WHILE_CONVERTING_FROM_DOUBLE         , "Rounding occurred while converting from double" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_TO_SINGLE                     , "A double rounding occurred in round to single" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_TO_DOUBLE_DOUBLE              , "A double rounding occurred in round to double-double" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_TO_TRIPLE_DOUBLE              , "A double rounding occurred in round to triple-double" },
  { SOLLYA_MSG_ROUNDING_DOWN_BEFORE_PRINTING_DOUBLE                   , "A round-down occurred before printing a double precision value" },
  { SOLLYA_MSG_ROUNDING_UP_BEFORE_PRINTING_DOUBLE                     , "A round-up occurred before printing a double precision value" },
  { SOLLYA_MSG_COULD_NOT_FIGURE_OUT_ENDIANESS                         , "Could not figure out the endianess of the system" },
  { SOLLYA_MSG_ROUNDING_DOWN_BEFORE_PRINTING_SINGLE                   , "A round-down occurred before printing a single precision value" },
  { SOLLYA_MSG_ROUNDING_UP_BEFORE_PRINTING_SINGLE                     , "A round-up occurred before printing a single precision value" },
  { SOLLYA_MSG_SNAN_MIGHT_HAVE_BECOME_QNAN                            , "An sNaN might have become a qNaN" },
  { SOLLYA_MSG_UNABLE_TO_CONVERT_FROM_HEXADECIMAL_CONSTANT            , "Unable to convert from a hexadecimal constant" },
  { SOLLYA_MSG_GIVEN_FUNCTION_IS_NO_POLYNOMIAL                        , "The given function is no polynomial" },
  { SOLLYA_MSG_NUM_OF_FORMATS_DOES_NOT_CORRESPOND_TO_DEGREE           , "The number of formats does not correspond to the degree of the polynomial" },
  { SOLLYA_MSG_ERROR_WHILE_EXTRACTING_COEFFICIENTS_OF_POLY            , "Error while extracting the coefficients of a polynomial" },
  { SOLLYA_MSG_ERROR_POLY_COEFF_GETS_ROUNDED                          , "A coefficient of a polynomial is not constant and gets rounded" },
  { SOLLYA_MSG_ERROR_EVALUATION_OF_POLY_COEFF_NOT_FAITHFUL            , "The evaluation of a coefficient of a polynomial does not give a faithful rounding" },
  { SOLLYA_MSG_ERROR_UNKNOWN_EXPANSION_FORMAT                         , "An unknown expansion format is given" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_ON_HANDLING_POLY_COEFF                 , "A double rounding occurred while handling the evaluation of a coefficient of a polynomial" },
  { SOLLYA_MSG_AT_LEAST_ONE_POLY_COEFF_HAS_BEEN_ROUNDED               , "At least one of the coefficients of a polynomial has been rounded" },
  { SOLLYA_MSG_NONE_OF_THE_POLY_COEFFS_HAS_BEEN_ROUNDED               , "None of the coefficients of a polynomial has been rounded" },
  { SOLLYA_MSG_NON_REAL_NUMBER_CANNOT_BE_DOUBLE_EXPANSION             , "A number that is not real cannot be displayed as a double expansion" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_ON_CONVERSION                          , "A double rounding occurred unexpectly on a conversion" },
  { SOLLYA_MSG_DOUBLE_EXPANSION_INCOMPLETE                            , "A double expansion is incomplete because of the limited exponent range of double precision" },
  { SOLLYA_MSG_ROUNDING_WHILE_SIMPLIFYING_TO_POLYNOMIAL               , "A rounding occurred while simplifying an expression to a polynomial" },
  { SOLLYA_MSG_POLY_COEFF_IS_NOT_CONSTANT                             , "A coefficient of a polynomial is not a constant expression" },
  { SOLLYA_MSG_SOME_EVALUATION_IS_NOT_FAITHFUL                        , "Some evaluation of a constant expression fails to give a faithful rounding" },
  { SOLLYA_MSG_DOUBLE_ROUNDING_IN_ROUND_IEEE_754_2008_OPERATOR        , "A double rounding occurred during invocation of an IEEE 754-2008 rounding operator" },
  { SOLLYA_MSG_STRING_CANNOT_BE_PARSED_BY_MINIPARSER                  , "A given string cannot be parsed by the mini-parser" },
  { SOLLYA_MSG_ERROR_ON_RUNNING_GUESSDEGREE                           , "Some error occurred while executing guessdegree" },
  { SOLLYA_MSG_FILE_EXECUTION_ASKED_FOR_QUIT_NOT_QUITTING             , "The execution of a file read by execute demanded stopping the interpretation but it is not stopped" },
  { SOLLYA_MSG_EXPR_SHOULD_BE_CONSTANT_AND_SEEMS_CONSTANT             , "An expression should be constant in a context. It seems constant but this could not be proven" },
  { SOLLYA_MSG_EXPR_SHOULD_BE_CONSTANT_AND_IS_CONSTANT_ON_FP          , "An expression should be constant in a context. It seems constant when floating-point evaluation is used" },
  { SOLLYA_MSG_EXPR_SHOULD_BE_CONSTANT_AND_IS_NOT_FAITHFUL            , "An expression should be constant in a context and faithful evaluation is not possible. Taking zero" },
  { SOLLYA_MSG_EXPR_SHOULD_BE_CONSTANT_NO_FAITHFUL_PLAIN_FP           , "An expression should be constant in a context and faithful evaluation is not possible. Performing plain FP evaluation" },
  { SOLLYA_MSG_FAITHFUL_ROUNDING_FOR_EXPR_THAT_SHOULD_BE_CONST        , "Taking a faithful rounding for an expression that should be a constant" },
  { SOLLYA_MSG_CONSTANT_IS_NOT_MACHINE_INTEGER_WILL_ROUND             , "A constant that should be an integer is not a machine integer. The nearest machine integer will be used instead" },
  { SOLLYA_MSG_PRECISION_OF_NUMBERS_MUST_BE_AT_LEAST_TWO_BITS         , "The precision of numbers must be at least 2 bits. Will use 2 bits of precision" },
  { SOLLYA_MSG_IDENTIFIER_ALREADY_BOUND                               , "An identifier is already bound to the free variable, to a library function, library constant or to an external procedure" },
  { SOLLYA_MSG_IDENTIFIER_REASSIGNMENT                                , "An identifier has already been assigned. This assignment is a reassignment" },
  { SOLLYA_MSG_DISPLAYED_VALUE_IS_FAITHFULLY_ROUNDED                  , "A rounding has happened but the displayed value is a faithful rounding of the true result" },
  { SOLLYA_MSG_EXPRESSION_UNDEFINED_OR_UNSTABLE                       , "The given expression is undefined or numerically unstable" },
  { SOLLYA_MSG_ROUNDING_MAY_HAVE_HAPPENED_AND_NOT_FAITHFUL            , "Rounding may have happened and if there is rounding, the displayed value is not guaranteed to be a faithful rounding of the true result" },
  { SOLLYA_MSG_EVALUATION_WITH_PLAIN_FP_ARITHMETIC                    , "The displayed value has been computed using plain floating-point arithmetic and might be completely wrong" },
  { SOLLYA_MSG_ROUNDING_MAY_HAVE_HAPPENED_SOMEWHERE                   , "Rounding may have happened" },
  { SOLLYA_MSG_EXPRESSION_TOO_BIG_FOR_HORNER_FORM                     , "The expression is too big for being written in Horner form" },
  { SOLLYA_MSG_EXPRESSION_TOO_BIG_FOR_CANONICAL_FORM                  , "The expression is too big for being written in canonical form" },
  { SOLLYA_MSG_DOUBLE_SIMPLIFICATION_NECESSARY                        , "A double simplification is necessary" },
  { SOLLYA_MSG_COMMAND_NOT_EXECUTABLE                                 , "The last command could not be executed. May leak memory" },
  { SOLLYA_MSG_TIMER_UNUSABLE                                         , "Unable to use the timer. Measures may be untrustable" },
  { SOLLYA_MSG_CAN_MODIFY_ONLY_ELEMENTS_OF_STRUCTURES                 , "Cannot modify an element of something that is not a structure" },
  { SOLLYA_MSG_CONTROL_STRUCTURE_NOT_EXECUTABLE_EXPR_NO_BOOLEAN       , "The given expression does not evaluate to a boolean" },
  { SOLLYA_MSG_AT_END_OF_FOR_CNTRL_VAR_NO_LONGER_ASSIGNABLE           , "At the end of a for loop, the loop variable cannot longer be assigned to" },
  { SOLLYA_MSG_AT_END_OF_FOR_CNTRL_VAR_NO_LONGER_CONSTANT             , "At the end of a for loop, the loop variable decreased by the loop step does no longer evaluate to a constant" },
  { SOLLYA_MSG_TOOL_HAS_BEEN_RESTARTED_INSIDE_LOOP                    , "The tool has been restarted inside a loop" },
  { SOLLYA_MSG_CNTRL_VAR_OF_LOOP_CANNOT_BE_ASSIGNED                   , "The control variable of a loop cannot be assigned to" },
  { SOLLYA_MSG_ARGS_OF_FOR_LOOP_NOT_CONSTANT                          , "At least one of the arguments of a loop does not evaluate to a constant" },
  { SOLLYA_MSG_FOR_IN_LOOP_OVER_EMPTY_LIST                            , "Executing a for in statement on an empty list" },
  { SOLLYA_MSG_FOR_IN_LOOP_OVER_END_ELLIPTIC_LIST_NOT_ALLOWED         , "The given expression does not evaluate to a non-elliptic list" },
  { SOLLYA_MSG_AT_LEAST_ONE_OPERATION_MUST_BE_EXECUTED                , "At least one operation must be executed" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_MACHINE_INTEGER              , "A given expression does not evaluate to a machine integer" },
  { SOLLYA_MSG_RESTART_IN_FILE_READ_INTO_ANOTHER                      , "A quit command has been used in a file read into another" },
  { SOLLYA_MSG_QUIT_IN_FILE_READ_INTO_ANOTHER                         , "A restart command has been used in a file read into another" },
  { SOLLYA_MSG_IDENTIFIER_IS_FREE_VAR_CANNOT_BE_LOCAL_VAR             , "An identifier is already bound to the current free variable. It cannot be declared as a local variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_FUNC_CANNOT_BE_LOCAL_VAR         , "An identifier is already bound to a library function. It cannot be declared as a local variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_CONST_CANNOT_BE_LOCAL_VAR        , "An identifier is already bound to a library constant. It cannot be declared as a local variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_EXTERNAL_PROC_CANNOT_BE_LOCAL_VAR        , "An identifier is already bound to an external procedure. It cannot be declared as a local variable" },
  { SOLLYA_MSG_FRAME_SYSTEM_CORRUPTED_LOCAL_VAR_NOT_DECLARED          , "Previous command interruptions have corrupted the frame system. Some local variable cannot be declared" },
  { SOLLYA_MSG_FILE_COULD_NOT_BE_OPENED_FOR_WRITING                   , "A file could not be opened for writing" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_STRING                       , "A given expression does not evaluate to a string" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_LIST_OF_FUNCTIONS            , "A given expression does not evaluate to a list of pure functions" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_RANGE                        , "A given expression does not evaluate to a range" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_STRING_NOR_DEFAULT           , "A given expression does not evaluate to a string nor to a default value" },
  { SOLLYA_MSG_IMPLEMENTATION_HAS_NOT_SUCCEEDED                       , "The implementation has not succeeded" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_CONSTANT                     , "A given expression does not evaluate to a constant" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_AN_EXPRESSION                , "A given expression does not evaluate to an expression" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_A_FUNCTION                   , "A given expression does not evaluate to a function" },
  { SOLLYA_MSG_ROUNDING_WHILE_PRINTING                                , "A rounding occurred while printing" },
  { SOLLYA_MSG_BASH_RETURNS_A_CERTAIN_RETURN_VALUE                    , "After executing a command, bash returns a certain return value" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_ABS_NOR_REL                  , "A given expression does not evaluate to neither absolute nor relative" },
  { SOLLYA_MSG_FILE_COULD_NOT_BE_OPENED_FOR_APPENDING                 , "A file could not be opened for appending" },
  { SOLLYA_MSG_FILE_COULD_NOT_BE_OPENED_FOR_READING                   , "A file could not be opened for reading" },
  { SOLLYA_MSG_FREE_VARIABLE_HAS_BEEN_NAMED_SOMEHOW                   , "A certain name has been given to the free variable" },
  { SOLLYA_MSG_FREE_VARIABLE_HAS_BEEN_RENAMED                         , "The free variable has been renamed" },
  { SOLLYA_MSG_CAN_RENAME_ONLY_FREE_VARIABLE                          , "Only the free variable can be renamed. A variable with a different name cannot be renamed" },
  { SOLLYA_MSG_IDENTIFIER_IS_FREE_VAR_CANNOT_BE_EXTERNAL              , "An identifier is already bound to the current free variable. It cannot be bound to an external procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_BOUND_TO_VAR_CANNOT_BE_EXTERNAL          , "An identifier is already bound to some identifier. It cannot be bound to an external procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_CONST_CANNOT_BE_EXTERNAL         , "An identifier is already bound to a library constant. It cannot be bound to an external procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_EXTERNAL_PROC_CANNOT_BE_EXTERNAL         , "An identifier is already bound to an external procedure. It cannot be bound to an external procedure" },
  { SOLLYA_MSG_ERROR_OCCURRED_COMMAND_NOT_EXECUTED                    , "An error occurred. The command could not be executed" },
  { SOLLYA_MSG_ASSIGNMENT_WILL_HAVE_NO_EFFECT                         , "An assignment will have no effect" },
  { SOLLYA_MSG_ASSIGNMENT_OF_INDEXED_ELEMENTS_NOT_IN_RANGE            , "Assignments to indexed elements of lists are only allowed on indices in the existing range" },
  { SOLLYA_MSG_ASSIGNMENT_OF_INDEXED_EMPTY_LIST_ONLY_ON_ZERO          , "Assignments to indexed elements of empty lists are only allowed on index 0" },
  { SOLLYA_MSG_STRING_NOT_OF_LENGTH_ONE                               , "The given string is not of length one" },
  { SOLLYA_MSG_IDENTIFIER_NOT_BOUND_TO_LIST_OR_STRING                 , "A certain identifier is not bound to a list or to a string" },
  { SOLLYA_MSG_IDENTIFIER_NOT_ASSIGNED_TO                             , "A certain identifier is not assigned to anything" },
  { SOLLYA_MSG_FIRST_ELMENT_OF_LEFT_SIDE_NOT_IDENTIFIER               , "The first element of a left-hand side is not an identifier" },
  { SOLLYA_MSG_LEFT_HAND_SIDE_NOT_ELEMENT_OF_STRUCTURED_TYPE          , "The left-hand side is not an access to an element of a structured type" },
  { SOLLYA_MSG_IDENTIFIER_IS_FREE_VAR_CANNOT_BE_LIBRARY               , "An identifier is already bound to the current free variable. It cannot be bound to a library function or constant" },
  { SOLLYA_MSG_IDENTIFIER_IS_BOUND_TO_VAR_CANNOT_BE_LIBRARY           , "An identifier is already bound to some identifier. It cannot be bound to a library function or constant" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_CONST_CANNOT_BE_LIBRARY          , "An identifier is already bound to a library constant. It cannot be bound to a library function or constant" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_FUNC_CANNOT_BE_LIBRARY           , "An identifier is already bound to a library constant. It cannot be bound to a library function or constant" },
  { SOLLYA_MSG_IDENTIFIER_IS_EXTERNAL_PROC_CANNOT_BE_LIBRARY          , "An identifier is already bound to an external procedure. It cannot be bound to a library function or constant" },
  { SOLLYA_MSG_PREC_MUST_BE_AT_LEAST_TWELVE_BITS                      , "The precision of the tool must be at least 12 bits" },
  { SOLLYA_MSG_POINTS_MUST_BE_AT_LEAST_THREE_POINTS                   , "The number of points must be at least 3 points" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_DISPLAY_TYPE                 , "A given expression does not evaluate to either default, dyadic, powers, hexadecimal or binary" },
  { SOLLYA_MSG_VERBOSITY_MUST_NOT_BE_NEGATIVE                         , "The verbosity of the tool must not be negative" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_ON_OR_OFF                    , "A given expression does not evaluate to either on or off" },
  { SOLLYA_MSG_TAYLOR_RECURSIONS_MUST_NOT_BE_NEGATIVE                 , "The number of Taylor recursions must not be negative" },
  { SOLLYA_MSG_HOPITAL_RECURSIONS_MUST_NOT_BE_NEGATIVE                , "The number of Hopital recursions must not be negative" },
  { SOLLYA_MSG_EXPR_OR_COMMAND_COULD_NOT_BE_HANDLED                   , "A given expression or command could not be handled" },
  { SOLLYA_MSG_EXPR_NOT_CORRECTLY_TYPED                               , "At least one of the given expressions or a subexpression is not correctly typed or its evaluation has failed because of some error on a side-effect" },
  { SOLLYA_MSG_EVALUATION_CREATES_ERROR_SPECIAL_SYMBOL                , "Evaluation creates an error special symbol" },
  { SOLLYA_MSG_EXPR_TOO_BIG_FOR_AUTOMATIC_SIMPLIFICATION              , "A given expression is too big to be treated by the automatic simplification" },
  { SOLLYA_MSG_FPMINIMAX_LESS_FORMATS_THAN_MONOMIALS                  , "fpminimax: there are less formats indications than monomials" },
  { SOLLYA_MSG_FPMINIMAX_LESS_MONOMIALS_THAN_FORMATS                  , "fpminimax: there are less monomials indications than formats. The list of formats will be truncated" },
  { SOLLYA_MSG_FPMINIMAX_FORMAT_LIST_MALFORMED                        , "fpminimax: the formats list must contain only integers or formats" },
  { SOLLYA_MSG_FPMINIMAX_FORMAT_NEGATIVE_FOR_FP_COEFFS                , "fpminimax: a format indication is non-positive while floating-point coefficients are desired" },
  { SOLLYA_MSG_QUIT_OR_RESTART_MUST_NOT_BE_IN_MATCH                   , "A quit or restart command may not be part of the body of a match-with construct" },
  { SOLLYA_MSG_FRAME_SYSTEM_CORRUPTED_MATCH_NOT_EXECUTED              , "Previous command interruptions have corrupted the frame system. A match-with construct cannot be executed" },
  { SOLLYA_MSG_IDENTIFIER_IS_FREE_VAR_CANNOT_BE_MATCHED               , "An identifier is already bound to the current free variable. It cannot be used as a match variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_EXTERNAL_PROC_CANNOT_BE_MATCHED          , "An identifier is already bound to an external procedure. It cannot be used as a match variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_CONST_CANNOT_BE_MATCHED          , "An identifier is already bound to a library constant. It cannot be used as a match variable" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_FUNC_CANNOT_BE_MATCHED           , "An identifier is already bound to a library constant. It cannot be used as a match variable" },
  { SOLLYA_MSG_NO_MATCHING_CASE_FOUND                                 , "No matching expression found in a match-with construct and no default case given" },
  { SOLLYA_MSG_QUIT_OR_RESTART_MUST_NOT_BE_IN_PROC                    , "A quit or restart command may not be part of a procedure body" },
  { SOLLYA_MSG_IDENTIFIER_IS_FREE_VAR_CANNOT_BE_PARAMETER             , "An identifier is already bound to the current free variable. It cannot be used as a formal parameter of a procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_EXTERNAL_PROC_CANNOT_BE_PARAMETER        , "An identifier is already bound to an external procedure. It cannot be used as a formal parameter of a procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_CONST_CANNOT_BE_PARAMETER        , "An identifier is already bound to a library constant. It cannot be used as a formal parameter of a procedure" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_FUNC_CANNOT_BE_PARAMETER         , "An identifier is already bound to a library constant. It cannot be used as a formal parameter of a procedure" },
  { SOLLYA_MSG_FRAME_SYSTEM_CORRUPTED_PROC_NOT_EXECUTED               , "Previous command interruptions have corrupted the frame system. A procedure cannot be executed" },
  { SOLLYA_MSG_REMEZ_MONOMIAL_DEGREES_MUST_NOT_BE_NEGATIVE            , "Monomial degrees must be non-negative" },
  { SOLLYA_MSG_REMEZ_MONOMIAL_DEGREE_GIVEN_TWICE                      , "A monomial degree is given twice in argument to Remez algorithm" },
  { SOLLYA_MSG_REMEZ_TOO_MANY_ARGUMENTS                               , "Too many arguments given to remez command. The remaining arguments will be ignored" },
  { SOLLYA_MSG_REMEZ_SECND_ARG_MUST_BE_NONNEGATIVE_INT_OR_LIST        , "The second argument of remez must be a non-negative integer or a list" },
  { SOLLYA_MSG_FPMINIMAX_TOO_MANY_ARGUMENTS                           , "Too many arguments given to fpminimax command. The remaining arguments will be ignored" },
  { SOLLYA_MSG_INVALID_FIFTH_ARGUMENT                                 , "fpminimax: invalid fifth argument" },
  { SOLLYA_MSG_FPMINIMAX_SECND_ARG_MUST_BE_NONNEG_INT_OR_LIST         , "The second argument of fpminimax must be a non-negative integer or a list" },
  { SOLLYA_MSG_FPMINIMAX_THIRD_ARG_MUST_BE_FORMAT_INDICATIONS         , "fpminimax: the third argument of fpminimax must be a list of formats indications" },
  { SOLLYA_MSG_FPMINIMAX_FOURTH_ARG_INTERVAL_OR_LIST_OF_POINTS        , "fpminimax: the fourth argument of fpminimax must be either an interval or a list of points" },
  { SOLLYA_MSG_TEST_COMPARES_ERROR_TO_SOMETHING                       , "The evaluation of one of the sides of a test yields error due to a syntax error or an error on a side-effect. The other side either also yields error due to an syntax or side-effect error or does not evaluate to error. The boolean returned may be meaningless" },
  { SOLLYA_MSG_TEST_RELIES_ON_FP_RESULT_THAT_IS_NOT_FAITHFUL          , "A test relies on floating-point result that is not faithfully evaluated" },
  { SOLLYA_MSG_TEST_RELIES_ON_FP_RESULT                               , "A test relies on floating-point result that is faithfully rounded or not" },
  { SOLLYA_MSG_TEST_RELIES_ON_FP_RESULT_FAITHFUL_BUT_UNDECIDED        , "The tool is unable to decide a test by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal" },
  { SOLLYA_MSG_TEST_RELIES_ON_FP_RESULT_FAITHFUL_BUT_NOT_REAL         , "A test relies on floating-point result that is faithfully evaluated and at least one of the sides is not a real number" },
  { SOLLYA_MSG_MIN_RELIES_ON_FP_RESULT_THAT_IS_NOT_FAITHFUL           , "A minimum computation relies on floating-point result that is not faithfully evaluated" },
  { SOLLYA_MSG_MIN_RELIES_ON_FP_RESULT                                , "A minimum computation relies on floating-point result that is faithfully rounded or not" },
  { SOLLYA_MSG_MIN_RELIES_ON_FP_RESULT_FAITHFUL_BUT_UNDECIDED         , "The tool is unable to decide a minimum computation by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal" },
  { SOLLYA_MSG_MAX_RELIES_ON_FP_RESULT_THAT_IS_NOT_FAITHFUL           , "A maximum computation relies on floating-point result that is not faithfully evaluated" },
  { SOLLYA_MSG_MAX_RELIES_ON_FP_RESULT                                , "A maximum computation relies on floating-point result that is faithfully rounded or not" },
  { SOLLYA_MSG_MAX_RELIES_ON_FP_RESULT_FAITHFUL_BUT_UNDECIDED         , "The tool is unable to decide a maximum computation by evaluation even though faithful evaluation of the terms has been possible. The terms will be considered to be equal" },
  { SOLLYA_MSG_ERROR_WHILE_EXECUTING_A_PROCEDURE                      , "Some error occurred while executing a procedure" },
  { SOLLYA_MSG_DIFFERENTIATING_FOR_EVAL_AS_START_PREC_LOW             , "Formal differentiation is performed during evaluation because the start precision is low" },
  { SOLLYA_MSG_FREE_VAR_INTERPRETED_AS_IDENTITY_FUNCTION              , "The identifier for the free variable is used in a functional context. It will be interpreted as the identity function" },
  { SOLLYA_MSG_EXTERNAL_PROCEDURE_SIGNALED_FAILURE                    , "An external procedure has signaled failure" },
  { SOLLYA_MSG_PRECISION_OF_NUMS_MUST_BE_AT_LEAST_TWELVE_BITS         , "The precision of numbers in the tool must be at least 12 bits" },
  { SOLLYA_MSG_ROUNDING_OCCURRED_WHILE_READING_A_CONSTANT             , "A rounding occurred while reading a constant" },
  { SOLLYA_MSG_RANGE_BOUNDS_IN_INVERSE_ORDER                          , "Range bounds are given in inverse order. They will get reverted" },
  { SOLLYA_MSG_LITERAL_STRUCTURE_CONTAINS_ENTRY_TWICE                 , "A literal structure contains at least one entry twice. This is not allowed" },
  { SOLLYA_MSG_NOT_LEAST_POSSIBLE_INCLUSION_INTERVAL                  , "Upon some evaluation, inclusion property is satisfied but the diameter may be greater than the least possible" },
  { SOLLYA_MSG_ONLY_ONE_ENDPOINT_OF_RANGE_IS_NAN                      , "One bound of a range is NaN while the other is not. Will normalize the range to have two NaN endpoints" },
  { SOLLYA_MSG_TREE_IS_CONSTANT_BUT_CANNOT_DO_FAITHFUL_EVAL           , "A given tree is constant but cannot be faithfully evaluated" },
  { SOLLYA_MSG_TIMED_COMMAND_HAS_QUIT_THE_TOOL                        , "A command executed in a timed environment required quitting the tool. This is not possible. The quit command has been discarded" },
  { SOLLYA_MSG_PARAM_OF_PROCEDURE_DOES_NOT_EXIST                      , "A given procedure has no argument named as indicated. The procedure is returned unchanged" },
  { SOLLYA_MSG_AUTODIFF_DEGREE_MUST_NOT_BE_NEGATIVE                   , "The degree of differentiation for automatic differentiation must not be negative" },
  { SOLLYA_MSG_EXPR_IS_NO_FRACTION                                    , "A given expression is not a fraction. Will consider it as a fraction with denominator 1" },
  { SOLLYA_MSG_NO_ROUNDING_HAS_HAPPENED                               , "No rounding has happened" },
  { SOLLYA_MSG_ROUND_UP_HAS_HAPPENED                                  , "Round-up has happened" },
  { SOLLYA_MSG_ROUND_DOWN_HAS_HAPPENED                                , "Round-down has happened" },
  { SOLLYA_MSG_XML_FILE_CANNOT_BE_READ                                , "A file could not be read in XML format" },
  { SOLLYA_MSG_FILE_COULD_NOT_BE_OPENED_FOR_WRITING_IGNORING          , "A file could not be opened for writing. Ignoring a proof argument" },
  { SOLLYA_MSG_SUPNORM_DID_NOT_WORK_OUT_WELL                          , "The supremum norm on the error function between the given polynomial and the given function could not be computed" },
  { SOLLYA_MSG_GUESSDEGREE_FIFTH_ARGUMENT_MUST_BE_NUMBER              , "guessdegree: the optional fifth argument must be a positive number" },
  { SOLLYA_MSG_ROUND_TO_NEAREST_IMPOSSIBLE_WITH_BOUNDING              , "A correct rounding to nearest is impossible with the given enclosure" },
  { SOLLYA_MSG_OUT_OF_CURRENT_EXPONENT_RANGE                          , "A certain value is out of the current exponent range. Displayed values may be wrong" },
  { SOLLYA_MSG_INADVERTED_ROUNDING_WHILE_DISPLAYING                   , "An inadverted rounding happened while displaying a value. The displayed value may be wrong" },
  { SOLLYA_MSG_EXPRESSION_HAS_BEEN_SIMPLIFIED                         , "An expression has been simplified" },
  { SOLLYA_MSG_EXPRESSION_HAS_BEEN_SIMPLIFIED_TO_ANOTHER_ONE          , "An expression has been simplified to another expression" },
  { SOLLYA_MSG_FORMALLY_DIFFERENTIATING_AN_EXPRESSION                 , "An expression gets formally differentiated" },
  { SOLLYA_MSG_FORMALLY_DIFFERENTIATING_A_PARTICULAR_EXPR             , "A particular expression gets formally differentiated" },
  { SOLLYA_MSG_EXPR_TOO_BIG_FOR_SIMPLIFICATION_BEFORE_DIFF            , "An expression is too big to be simplified before it gets formally differentiated" },
  { SOLLYA_MSG_DEGREE_OF_POLYNOMIAL_DOESNT_HOLD_ON_MACHINE_INT        , "The degree of a certain polynomial does not hold on a machine integer" },
  { SOLLYA_MSG_DEG_OF_MAX_POLY_DIV_DOESNT_HOLD_ON_MACHINE_INT         , "The degree of a the maximal polynomial divider a certain expression does not hold on a machine integer" },
  { SOLLYA_MSG_ROUNDING_UPON_BINOMIAL_COEFFICIENT_COMPUTATION         , "A rounding occurred while computing a binomial coefficient" },
  { SOLLYA_MSG_ROUNDING_UPON_POW_EXPONENT_COMPUTATION                 , "A rounding occurred while computing the exponent of an expanded power operator" },
  { SOLLYA_MSG_RECURSION_ON_POLY_COEFFICIENTS_EXTRACTION              , "Recursion has been necessary while extracting the coefficients of a polynomial" },
  { SOLLYA_MSG_POLY_COEFF_EXTRACTION_SPECIAL_ALGO_FOR_HORNER          , "A special algorithm for Horner forms is used when extracting the coefficients of a polynomial" },
  { SOLLYA_MSG_POLY_COEFF_EXTRACT_SPECIAL_ALGO_FOR_CANONICAL          , "A special algorithm for canonical forms is used when extracting the coefficients of a polynomial" },
  { SOLLYA_MSG_TRIED_TO_EXTRACT_COEFFS_OF_STH_NOT_POLYNOMIAL          , "A try was made to extract the coefficients of an expression that is not a polynomial" },
  { SOLLYA_MSG_EXPR_NOT_HORNERIZED_AS_ALREADY_HORNERIZED              , "A certain expression is not hornerized as it is already in Horner form" },
  { SOLLYA_MSG_ROUNDING_UPON_DIFFERENTIATION_OF_HORNER_POLY           , "Rounding has inadvertedly happened upon differentiation of an expression that was written in Horner form" },
  { SOLLYA_MSG_DIFFERENTIATION_USES_SPECIAL_ALGO_FOR_HORNER           , "A special algorithm for Horner forms is used when differentiating a Horner polynomial" },
  { SOLLYA_MSG_DIFFERENTIATION_USES_SPECIAL_ALGO_FOR_CANONICAL        , "A special algorithm for canonical forms is used when differentiating a canonically written polynomial" },
  { SOLLYA_MSG_ROUNDING_UPON_DIFFERENTIATION_OF_POLYNOMIAL            , "Rounding has inadvertedly happened upon differentiation of a polynomial" },
  { SOLLYA_MSG_EXPR_NOT_CANONICALIZED_AS_ALREADY_CANONICAL            , "A certain expression is not canonicalized as it is already in canonical form" },
  { SOLLYA_MSG_NO_COMMAND_PROVIDED                                    , "No command has been provided" },
  { SOLLYA_MSG_ERROR_WHILE_CREATING_A_PIPE                            , "Error while creating a pipe" },
  { SOLLYA_MSG_ERROR_WHILE_FORKING                                    , "Error while forking" },
  { SOLLYA_MSG_UNABLE_TO_WRITE_TO_BASH                                , "Unable to write to a bash command that has been forked" },
  { SOLLYA_MSG_THE_EXIT_CODE_OF_CHILD_PROCESS_IS                      , "A child process has exited with a certain exit code" },
  { SOLLYA_MSG_SAMPLING_PREC_MUST_BE_LOWER_THAN_CURR_PREC             , "The sampling precision must be lower than the current precision of the tool" },
  { SOLLYA_MSG_EXTERNALPLOT_COULD_NOT_OPEN_A_LIBRARY                  , "Externalplot could not open a library for some reason" },
  { SOLLYA_MSG_EXTERNALPLOT_DID_NOT_FIND_FUNCTION_F                   , "Externalplot did not find function f in the library" },
  { SOLLYA_MSG_COULD_NOT_OPEN_PLOT_FILE                               , "A certain plot file could not be opened" },
  { SOLLYA_MSG_A_FUNCTION_COULD_NOT_BE_PLOTTED_AT_A_POINT             , "A function could not be plotted at a certain point" },
  { SOLLYA_MSG_TOOL_DIES_ON_ERROR_AS_PER_DIE_ON_ERROR_MODE            , "The tool is going to die on an error as die-on-error mode is activated" },
  { SOLLYA_MSG_ERROR_ON_INITIAL_SETUP                                 , "An error occurred on initial setup of the tool" },
  { SOLLYA_MSG_FRAME_STACK_HAS_BEEN_CORRUPTED                         , "The frame stack has been corrupted" },
  { SOLLYA_MSG_TIMING_STACK_HAS_BEEN_CORRUPTED                        , "The timing stack has been corrupted" },
  { SOLLYA_MSG_LAST_COMMAND_INTERRUPTED                               , "The last command has been interrupted. May leak memory" },
  { SOLLYA_MSG_RELEASING_FRAME_STACK                                  , "The variable frame stack has been released" },
  { SOLLYA_MSG_COEFF_NOT_TWICE_GREATER_THAN_SUBPOLY                   , "A coefficient is not at least 2 times greater than a already evaluated sub-polynomial" },
  { SOLLYA_MSG_PREC_OF_HORNER_STEP_GREATER_THAN_FOR_PREV_ONE          , "The precision of a previous Horner step is greater than the one of the next" },
  { SOLLYA_MSG_NO_AUTO_ROUND_FOR_COEFF_W_PREC_HIGHER_THAN_TD          , "A coefficient's precision is higher than triple-double but no automatic rounding will be performed" },
  { SOLLYA_MSG_INFERED_COEFF_PREC_HIGHER_THAN_REQUIRED                , "The infered precision of a certain coefficient of the polynomial is greater than the necessary precision computed for this step" },
  { SOLLYA_MSG_COEFF_HAS_BEEN_ROUNDED_TO_TRIPLE_DOUBLE                , "A coefficient of the polynomial has automatically been rounded to a triple-double" },
  { SOLLYA_MSG_COEFF_HAS_BEEN_ROUNDED_TO_DOUBLE_DOUBLE                , "A coefficient of the polynomial has automatically been rounded to a double-double" },
  { SOLLYA_MSG_COEFF_HAS_BEEN_ROUNDED_TO_DOUBLE                       , "A coefficient of the polynomial has automatically been rounded to a double" },
  { SOLLYA_MSG_ERROR_ON_HANDLING_A_COEFFICIENT                        , "There was an error during the internal handling of a coefficient" },
  { SOLLYA_MSG_IMPLEMENTED_POLY_DIFFERS_FROM_ORIGINAL_ONE             , "During implementation, at least one coefficient of a given polynomial has been rounded so that the implemented polynomial differs from the original one" },
  { SOLLYA_MSG_COEFF_DOES_NOT_EVEN_HOLD_ON_TRIPLE_DOUBLE              , "Tried to implement a coefficient that cannot even be written on a triple-double" },
  { SOLLYA_MSG_ROUNDING_ON_INTERNAL_HANDLING_OF_A_COEFFICIENT         , "A rounding occurred on the internal handling of a coefficient" },
  { SOLLYA_MSG_A_COEFF_COULD_NOT_BE_STORED_IN_ANY_KNOWN_FORMAT        , "At least one of the coefficients of the given polynomial could not be stored in any known format" },
  { SOLLYA_MSG_IMPLEMENTPOLY_FREE_VAR_HAS_UNKNOWN_FORMAT              , "The free variable is not associated to any known format in implementpoly" },
  { SOLLYA_MSG_ERROR_IN_PRECISION_MANAGEMENT                          , "An error occurred in the internal management of precisions" },
  { SOLLYA_MSG_CURRENT_PREC_INSUFFICIENT_FOR_TD_CODE                  , "The current tool's precision is not sufficient for implementing triple-double code" },
  { SOLLYA_MSG_TARGET_ACCURACY_GREATER_OR_EQUAL_THAN_ONE              , "The target accuracy is greater than or equal to 1. This make no sense" },
  { SOLLYA_MSG_TARGET_ACCURACY_LESS_THAN_140_BITS                     , "The target accuracy is less than 2^(-140). Implementation is restricted to maximally triple-double" },
  { SOLLYA_MSG_INFERED_OUTPUT_PREC_LESS_THAN_VARIABLE_PREC            , "The infered output expansion type is less from the given variable type" },
  { SOLLYA_MSG_COEFF_DOES_NOT_HOLD_ON_TD_USING_FAITHFUL_EVAL          , "A coefficient of the given polynomial cannot exactly be represented on a triple-double. It will be evaluated first, using faithful rounding" },
  { SOLLYA_MSG_ERROR_ON_DETERMINING_THE_REQUIRED_PRECISIONS           , "An error occurred upon determination of the required precisions" },
  { SOLLYA_MSG_ERROR_ON_DETERMINING_THE_REQUIRED_POWERS               , "An error occurred upon determination of the required powers" },
  { SOLLYA_MSG_THE_POLY_THAT_GETS_IMPLEMENTED_IS                      , "A certain polynomial is obtained after rounding. This is the one that will get implemented" },
  { SOLLYA_MSG_ERROR_ON_CODE_GENERATION_FOR_COEFFICIENTS              , "An error occurred upon code generation for the polynomial's coefficients" },
  { SOLLYA_MSG_COULD_NOT_WRITE_TO_THE_IMPLEMENTATION_FILE             , "The implementation file could not be written to" },
  { SOLLYA_MSG_ERROR_ON_CODE_GENERATION_FOR_POWERS_OF_FREE_VAR        , "An error occurred upon code generation for the powers of the free variable" },
  { SOLLYA_MSG_ERROR_ON_CODE_GENERATION_FOR_HORNER_SCHEME             , "An error occurred upon code generation for the Horner scheme" },
  { SOLLYA_MSG_EXPR_SEEMS_TO_BE_ZERO_INCREASE_PREC                    , "An expression seems to be exactly zero. If it is not, try to increase the tool precision" },
  { SOLLYA_MSG_A_BASE_FUNC_IS_NOT_SUPPORTED_BY_IMPLEMENTCONST         , "A certain base function is not supported by implementconst" },
  { SOLLYA_MSG_XML_PARSER_CHANGE                                      , "There is a change of the current XML parser" },
  { SOLLYA_MSG_XML_PARSER_INDEX_CHANGE                                , "There is a change in the index of the current XML parser" },
  { SOLLYA_MSG_XML_PARSER_STATE_INFORMATION                           , "The XML parser prints some information of its current state" },
  { SOLLYA_MSG_ROUNDING_ON_READING_CONSTANT_IN_XML_FILE               , "Rounding has happened on reading a constant in an XML file" },
  { SOLLYA_MSG_XML_PARSER_FAILURE                                     , "Failed to parse a certain XML file" },
  { SOLLYA_MSG_XML_SYNCHRONIZATION_LOST_TRYING_TO_RESYNCH             , "The XML parser has lost synchronization and is trying to resynchronize" },
  { SOLLYA_MSG_XML_PARSER_UNABLE_TO_OPEN_A_CERTAIN_FILE               , "The XML parser cannot open a certain file" },
  { SOLLYA_MSG_XML_PARSE_FUNCTIONALITY_NOT_COMPILED_IN                , "A certain XML file cannot be read because XInclude functionnality has not been compiled in" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_INTEGER                      , "A given expression does not evaluate to an integer" },
  { SOLLYA_MSG_ROUNDING_ON_CONVERTING_A_MACHINE_INTEGER               , "A rounding has occurred during the conversion of a machine integer" },
  { SOLLYA_MSG_HARMLESS_ERROR_OCCURRED_COMMAND_NOT_EXECUTED           , "An error occurred. The last command will not succeed. This is harmless" },
  { SOLLYA_MSG_INPUT_AND_OUTPUT_PRECISION_MUST_BE_GREATER_TEN         , "The input and output precisions must be greater than 10" },
  { SOLLYA_MSG_INTERNAL_PREC_LESS_THAN_IN_AND_OUT_PREC                , "The internal precision must not be less than the input and output precisions" },
  { SOLLYA_MSG_EPS_SPECIFIED_GREATER_THAN_HALFULP_OF_OUT_PREC         , "The specified epsilon is greater than half an ulp of the specified output format" },
  { SOLLYA_MSG_GIVEN_EPS_MUST_BE_POSITIVE_TAKING_ABS                  , "The specified epsilon value must be positive. Taking its absolute value" },
  { SOLLYA_MSG_CERTAIN_AMOUNT_OF_CASES_HANDLED                        , "A certain amount of cases has been handled" },
  { SOLLYA_MSG_FUNC_EVALUATED_TO_ZERO_TAKING_ABSOLUTE_ERROR           , "The given function evaluates to zero at a certain point. Considering an absolute error instead of a relative error at this point" },
  { SOLLYA_MSG_CANNOT_PERFORM_MORE_THAN_63_STEPS                      , "A certain command cannot perform more than 63 steps. Will decrease the number of steps to 63" },
  { SOLLYA_MSG_SEARCH_PREC_HIGHER_THAN_TOOL_PREC                      , "The required search precision is higher that the current tool precision. No search is possible" },
  { SOLLYA_MSG_NUMBERS_OF_FUNCS_AND_FORMATS_DIFFER                    , "The numbers of the given functions, formats and accuracies differ. No search is possible" },
  { SOLLYA_MSG_START_POINT_TOO_PRECISE_FOR_GIVEN_INPUT_PREC           , "The given start point is too precise for the given search precision. It gets rounded beforehand" },
  { SOLLYA_MSG_DEGREE_OF_TAYLORFORM_MUST_BE_AT_LEAST_ZERO             , "The degree of a Taylor form must be at least zero" },
  { SOLLYA_MSG_ERROR_IN_TAYLORFORM_MULTIPLYING_INCOMPAT_MODELS        , "Error in Taylor form computation: multiplication of incompatible models" },
  { SOLLYA_MSG_ERROR_IN_TAYLORFORM_UNKNOWN_FUNC_FOR_ZUMKELLER         , "Error in Taylor form computation: unkown type of function used with Zumkeller's technique" },
  { SOLLYA_MSG_ERROR_IN_TAYLORFORM_TRYING_TO_INCREASE_DEGREE          , "Error in Taylor form computation: trying to increase the degree of a model" },
  { SOLLYA_MSG_DEVELOPMENT_POINT_NOT_CONSTANT                         , "The expression given as a development point is not constant" },
  { SOLLYA_MSG_ROUNDING_ON_COMPUTATION_OF_TAYLOR_COEFFICIENT          , "A rounding occurred while computing the constant factor of a Taylor coefficient" },
  { SOLLYA_MSG_ROUNDING_ON_COMPUTATION_OF_TAYLOR_POWER                , "A rounding occurred while computing the exponent of a power in a Taylor development" },
  { SOLLYA_MSG_A_CHARACTER_COULD_NOT_BE_RECOGNIZED                    , "A certain character could not be recognized while lexing" },
  { SOLLYA_MSG_A_FILE_COULD_NOT_BE_OPENED_FOR_READING                 , "A certain file could not be opened for reading" },
  { SOLLYA_MSG_SPACES_REMOVED_FROM_CONSTANT_IN_SCIENTIF_NOTAT         , "Spaces have been removed from a constant written in scientific notation" },
  { SOLLYA_MSG_SYNTAX_ERROR_ENCOUNTERED_WHILE_PARSING                 , "Syntax error encountered while parsing" },
  { SOLLYA_MSG_SUPNORM_NO_TAYLOR                                      , "During supnorm computation, no suitable Taylor form could be found" },
  { SOLLYA_MSG_SUPNORM_NOT_ENOUGH_WORKING_PRECISION                   , "During supnorm computation, no result could be found as the working precision seems to be too low" },
  { SOLLYA_MSG_SUPNORM_SINGULARITY_NOT_REMOVED                        , "During supnorm computation, a singularity in the expression tree could not be removed" },
  { SOLLYA_MSG_SUPNORM_COULD_NOT_SHOW_POSITIVITY                      , "During supnorm computation, the positivity of a polynomial could not be established" },
  { SOLLYA_MSG_SUPNORM_SINGULARITY_NOT_DETECTED                       , "During supnorm computation, a false singularity could not be detected" },
  { SOLLYA_MSG_SUPNORM_ANOTHER_SINGULARITY_IN_DOM                     , "During supnorm computation, there appeared to be at least two singularities in the domain. More bisection is needed" },
  { SOLLYA_MSG_SUPNORM_CANNOT_COMPUTE_LOWER_BOUND                     , "During supnorm computation, it was not possible to determine a valid lower bound for the error function" },
  { SOLLYA_MSG_SUPNORM_CANNOT_COMPUTE_ABSOLUTE_INF                    , "During supnorm computation, it was not possible to determine a valid lower bound for the absolute value of the function" },
  { SOLLYA_MSG_SUPNORM_CANNOT_DETERMINE_SIGN_OF_T                     , "During supnorm computation, it was not possible to safely determine the sign of the Taylor polynomial" },
  { SOLLYA_MSG_SUPNORM_CANNOT_DETERMINE_ORDER_OF_SINGU                , "During supnorm computation, it was not possible to safely determine the order of a presume zero of the given function" },
  { SOLLYA_MSG_SUPNORM_GENERIC_ERROR                                  , "During supnorm computation, some generic error occured. No further description is available" },
  { SOLLYA_MSG_SUPNORM_ACCURACY_TOO_HIGH                              , "For supnorm, the given accuracy depasses the current maximum precision. Try to increase the precision of the tool" },
  { SOLLYA_MSG_SUPNORM_COULD_NOT_FAITHFULLY_EVAL_ERROR_FUNC           , "During supnorm computation, the error function between the function and the polynomial could not faithfully be evaluated at some point" },
  { SOLLYA_MSG_DOMAIN_IS_NO_CLOSED_INTERVAL_ON_THE_REALS              , "The given domain is not a closed interval on the reals" },
  { SOLLYA_MSG_DOMAIN_IS_EMPTY                                        , "The given domain is empty" },
  { SOLLYA_MSG_DOMAIN_IS_REDUCED_TO_A_POINT_WILL_SIMPLY_EVAL          , "The given domain is reduced to a point. Will simply evaluate at this point" },
  { SOLLYA_MSG_SUPNORM_COULD_NOT_EVALUATE_ERROR_FUNC                  , "During supnorm computation, the error function between the function and the polynomial could not be evaluated at some point" },
  { SOLLYA_MSG_ACCUARCY_INDICATION_IS_NOT_A_REAL_NUMBER               , "The given accuracy indication is not a real number" },
  { SOLLYA_MSG_ACCUARCY_INDICATION_IS_ZERO                            , "The given accuracy indication is zero" },
  { SOLLYA_MSG_POLYNOMIAL_HAS_NON_DYADIC_COEFFICIENTS                 , "The given polynomials contains coefficients that are no dyadic numbers" },
  { SOLLYA_MSG_SUPNORM_SAFE_ENCLOSURE_COULD_NOT_BE_COMPUTED           , "An error occured during supremum norm computation. A safe enclosure of the supremum norm could not be computed" },
  { SOLLYA_MSG_STURM_INTERVAL_A_CERTAIN_PREC_HAS_BEEN_CHOSEN          , "During execution of Sturm's algorithm in interval arithmetic, a certain precision has been chosen" },
  { SOLLYA_MSG_STURM_COEFF_EVALUATED_TO_RATIONAL_NUMBER               , "A coefficient of the given polynomial has been evaluated to a certain rational number" },
  { SOLLYA_MSG_STURM_COEFF_NOT_CONSTANT_NOR_RATIONAL_ROUNDING         , "A coefficient of the given polynomial is neither a floating point or rational constant nor can be evaluated without rounding to a floating point constant" },
  { SOLLYA_MSG_STURM_COEFF_ROUNDED_TO_ZERO                            , "A coefficient of the given polynomial has been rounded to zero" },
  { SOLLYA_MSG_STURM_USING_SLOWER_ALGORITHM_ON_RATIONALS              , "Sturm's algorithm gets executed on rational numbers instead of being executed on intervals" },
  { SOLLYA_MSG_STURM_POLY_IS_ZERO_POLY                                , "The given polynomial is the zero polynomial. It has an infinite number of zeros in the interval" },
  { SOLLYA_MSG_CONSTANT_EXPR_CANNOT_BE_EVALUATED_AT_ALL               , "A certain constant expression cannot be evaluated at all" },
  { SOLLYA_MSG_PLOT_OVERFLOW_OCCURRED_ON_CONVERSION_TO_DOUBLE         , "An overflow occurred in a conversion mpfr to double while plotting" },
  { SOLLYA_MSG_PLOT_FUNC_PROVEN_LESS_THAN_2_TO_MINUS_PREC             , "While plotting a function, it was proven to be less than 2^(-prec) at some point, where prec is the current tool precision. It gets plotted with an ordinate inside the proof interval" },
  { SOLLYA_MSG_PLOT_FUNC_UNDEFINED_OR_UNSTABLE_AT_POINT               , "A function to be plotted is undefined or numerically unstable at some point" },
  { SOLLYA_MSG_PLOT_NOT_FAITHFULLY_EVALUATED_AT_SOME_POINT            , "A function to be plotted has not been faithfully evaluated at at least one point" },
  { SOLLYA_MSG_DOMAIN_IS_REDUCED_TO_A_POINT_TRIVIAL_RESULT            , "The given domain is reduced to a point. The result is trivial" },
  { SOLLYA_MSG_EXTERNAL_FUNC_OR_PROC_ALREADY_BOUND                    , "An external function or external procedure with the same name has already been bound to the tool" },
  { SOLLYA_MSG_COULD_NOT_OPEN_LIBRARY_WITH_EXTERN_FUNC_OR_PROC        , "A library with an external function or procedure could not be opened" },
  { SOLLYA_MSG_EXTERNAL_FUNC_OR_PROC_NOT_FOUND_IN_LIBRARY             , "No external function or external procedure with the given name could be found in the given library" },
  { SOLLYA_MSG_COULD_NOT_CLOSE_LIBRARY                                , "A library could not be closed" },
  { SOLLYA_MSG_ENTERING_NEWTONS_ALGORITHM                             , "Entering Newton's algorithm. Certain parameters are given" },
  { SOLLYA_MSG_NEWTON_ZERO_IS_EXACT_ZERO                              , "Newton's algorithm: zero is an exact zero" },
  { SOLLYA_MSG_NEWTON_AN_EXACT_ZERO_HAS_BEEN_FOUND                    , "Newton's algorithm: an exact zero has been found" },
  { SOLLYA_MSG_ERROR_IN_TAYLORFORM_COPYING_INCOMPAT_MODELS            , "Error in Taylor form computation: copy of incompatible models" },
  { SOLLYA_MSG_PLOT_COULD_NOT_OPEN_FILE                               , "A certain file could not be opened for writing while attempting to plot" },
  { SOLLYA_MSG_NEWTON_FUNC_APPEARS_TO_HAVE_MORE_THAN_ONE_ZERO         , "Newton's algorithm: the function has more than one zero in the interval" },
  { SOLLYA_MSG_NEWTON_ZERO_TOO_CLOSE_TO_ZERO_TO_BE_ACCURATE           , "Newton's algorithm: the zero of the function is too close to zero for being accurately determined" },
  { SOLLYA_MSG_NEWTON_ZERO_SEEMS_TO_BE_ZERO_NO_PROOF                  , "Newton's algorithm: zero seems to be a zero of function, which cannot be proved" },
  { SOLLYA_MSG_NEWTON_ALGORITHM_FAILS_DUE_TO_NUMERICAL_ISSUES         , "Newton's algorithm fails due to numerical issues" },
  { SOLLYA_MSG_NEWTON_ALGORITHM_FAILS_TO_LOCATE_ZERO                  , "Newton's algorithm fails to locate the zero" },
  { SOLLYA_MSG_NEWTON_PERFORMING_BISECTION_STEP                       , "Newton's algorithm: performing a bisection step" },
  { SOLLYA_MSG_NEWTON_PERFORMING_TRISECTION_STEP                      , "Newton's algorithm: performing a trisection step" },
  { SOLLYA_MSG_NEWTON_FINISHED_AFTER_NUMBER_OF_STEPS                  , "Newton's algorithm has finished after a certain number of steps" },
  { SOLLYA_MSG_REMEZ_EXCHANGE_TAKE_A_CERTAIN_MINIMUM                  , "Remez: an exchange step takes a certain minimum to perform the exchange" },
  { SOLLYA_MSG_REMEZ_EXCHANGE_TAKE_A_CERTAIN_MAXIMUM                  , "Remez: an exchange step takes a certain maximum to perform the exchange" },
  { SOLLYA_MSG_REMEZ_FUNCTION_OSCILLATES_TOO_MUCH                     , "Remez: the error function oscillates too much" },
  { SOLLYA_MSG_REMEZ_PERFORMING_AN_EXCHANGE_STEP                      , "Remez: performing an exchange step" },
  { SOLLYA_MSG_REMEZ_COMPUTED_INFNORM_IS_A_CERTAIN_VALUE              , "Remez: the computed infinity norm of the current error function takes a certain value" },
  { SOLLYA_MSG_REMEZ_FAILED_TO_FIND_PSEUDOALTERNATING_POINTS          , "Remez: failed to find pseudo-alternating points" },
  { SOLLYA_MSG_REMEZ_CONSTRUCTING_THE_ERROR_TREE                      , "Remez: constructing the error tree" },
  { SOLLYA_MSG_REMEZ_CONSTRUCTING_THE_ERROR_PRIME_TREE                , "Remez: constructing the error' tree" },
  { SOLLYA_MSG_REMEZ_CONSTRUCTING_THE_ERROR_SECOND_TREE               , "Remez: constructing the error'' tree" },
  { SOLLYA_MSG_REMEZ_COMPUTING_THE_YI                                 , "Remez: computing the yi" },
  { SOLLYA_MSG_REMEZ_THE_COMPUTED_YI_ARE_CERTAIN_VALUES               , "Remez: the computed yi are certain values" },
  { SOLLYA_MSG_REMEZ_ALGORITHM_IS_IN_A_CERTAIN_CASE                   , "Remez: the algorithm is in a certain case" },
  { SOLLYA_MSG_REMEZ_THE_COMPUTED_SIGNS_ARE_CERTAIN_VALUES            , "Remez: the computed signs take certain values" },
  { SOLLYA_MSG_REMEZ_SIGNS_COULD_NOT_BE_EVALUATED                     , "Remez: the signs could not be evaluated" },
  { SOLLYA_MSG_REMEZ_MAIN_HEURISTIC_FAILED_USING_SLOWER_ALGO          , "Remez: the main heuristic failed; using a slower algorithm" },
  { SOLLYA_MSG_REMEZ_SLOWER_ALGORITHM_USED_FOR_A_STEP                 , "Remez: a slower algorithm is used for a certain step" },
  { SOLLYA_MSG_REMEZ_THE_NEW_POINTS_ARE_CERTAIN_VALUES                , "Remez: the new points take certain values" },
  { SOLLYA_MSG_REMEZ_THE_CURRENT_NORM_TAKES_A_CERTAIN_VALUE           , "Remez: the current norm takes a certain value" },
  { SOLLYA_MSG_ENTERING_REMEZ_FUNCTION                                , "Entering the Remez function. Certain parameters are given" },
  { SOLLYA_MSG_REMEZ_COMPUTING_MONOMIALS                              , "Remez: computing the monomials" },
  { SOLLYA_MSG_REMEZ_COMPUTING_INITIAL_POINT_SET                      , "Remez: computing an initial point set" },
  { SOLLYA_MSG_REMEZ_THE_COMPUTED_POINT_SET_IS_CERTAIN_VALUES         , "Remez: the computed point set contains certain values" },
  { SOLLYA_MSG_REMEZ_COMPUTING_THE_MATRIX                             , "Remez: computing the matrix" },
  { SOLLYA_MSG_REMEZ_COMPUTAT_OF_MATRIX_ENTRY_USES_SLOWER_ALGO        , "Remez: the computation of a certain matrix entry uses a slower algorithm" },
  { SOLLYA_MSG_REMEZ_DEGENERATED_SYSTEM_IN_NON_HAAR_CONTEXT           , "Remez: the system is degenerated in a non-Haar context" },
  { SOLLYA_MSG_REMEZ_SIGNS_FOR_PSEUDO_ALTERN_ARE_CERTAIN_VALS         , "Remez: the signs for the pseudo-alternation condition are certain values" },
  { SOLLYA_MSG_REMEZ_THE_COMPUTED_MATRIX_HAS_A_CERTAIN_VALUE          , "Remez: the computed matrix has a certain value" },
  { SOLLYA_MSG_REMEZ_SOLVING_THE_SYSTEM                               , "Remez: solving the system" },
  { SOLLYA_MSG_REMEZ_THE_COMPUTED_POLY_HAS_A_CERTAIN_VALUE            , "Remez: the computed polynomial has a certain value" },
  { SOLLYA_MSG_REMEZ_CURRENT_EPSILON_HAS_A_CERTAIN_VALUE              , "Remez: the current epsilon has a certain value" },
  { SOLLYA_MSG_REMEZ_DIFFERENTIATING_THE_COMPUTED_POLYNOMIAL          , "Remez: differentiating the computed polynomial" },
  { SOLLYA_MSG_REMEZ_SEARCHING_FOR_EXTREMA_OF_ERROR_FUNCTION          , "Remez: searching for the extrema of the error function" },
  { SOLLYA_MSG_REMEZ_THE_BEST_POLY_GIVES_A_CERTAIN_ERROR              , "Remez: the best polynomial that has been computed yields to a certain error" },
  { SOLLYA_MSG_REMEZ_CURRENT_QUALITY_HAS_A_CERTAIN_VALUE              , "Remez: the current quality has a certain value" },
  { SOLLYA_MSG_REMEZ_FINISHES_AS_TARGET_ERROR_IS_NOT_REACHABLE        , "The Remez algorithm finishes as the given target error is provably not reachable" },
  { SOLLYA_MSG_REMEZ_FINISHES_AS_TARGET_ERROR_HAS_BEEN_REACHED        , "The Remez algorithm finishes as the given target error has been reached" },
  { SOLLYA_MSG_REMEZ_FINISHES_AS_QUALITY_HAS_BEEN_REACHED             , "The Remez algorithm finishes as the specified quality has been reached" },
  { SOLLYA_MSG_REMEZ_FAILS_AND_LOOPS_AGAIN                            , "The Remez algorithm has failed (possible because of too many oscillations) and it loops again" },
  { SOLLYA_MSG_REMEZ_DOES_NOT_CONVERGE                                , "The Remez algorithm does not converge" },
  { SOLLYA_MSG_REMEZ_MAY_HAPPEN_NOT_TO_CONVRG_AS_DOM_IS_POINT         , "The Remez algorithm may happen not to converge because the given domain is reduced to a point" },
  { SOLLYA_MSG_GUESSDEGREE_TRYING_A_CERTAIN_DEGREE                    , "Guessdegree is about to try a certain degree" },
  { SOLLYA_MSG_GUESSDEGREE_NONE_OF_LESSER_DEGS_SATISFIES_ERROR        , "Guessdegree: none of the degrees less than a certain degree satisfies the target error" },
  { SOLLYA_MSG_GUESSDEGREE_TRYING_A_CERTAIN_DEG_WITHIN_BOUNDS         , "Guessdegree is about to try a certain degree within certain bounds" },
  { SOLLYA_MSG_GUESSDEG_NONE_OF_LESS_DEGS_SEEMS_TO_SATISFY_ERR        , "Guessdegree: none of the degrees less than a certain degree provably satisfy the target error" },
  { SOLLYA_MSG_FPMINIMAX_SINGULAR_MATRIX                              , "Fpminimax: the matrix is singular" },
  { SOLLYA_MSG_FPMINIMAX_A_CERTAIN_COEFF_IS_EXACT_ZERO                , "Fpminimax: a certain coefficient is an exact zero" },
  { SOLLYA_MSG_FPMINIMAX_MINIMAX_DOES_NOT_GIVE_ENOUGH_POINTS          , "Fpminimax: the minimax does not give enough points, switching to Chebyshev points" },
  { SOLLYA_MSG_FPMINIMAX_THE_POINTS_ARE_CERTAIN_VALUES                , "Fpminimax: the points are certain values" },
  { SOLLYA_MSG_FPMINIMAX_FAILED_TO_RECOVER_COEFFS_FROM_POLY           , "Fpminimax failed to recover the coefficients from the given pseudo-polynomial" },
  { SOLLYA_MSG_FPMINIMAX_THE_EXPONENTS_ARE_CERTAIN_VALUES             , "Fpminimax: the exponents are certain values" },
  { SOLLYA_MSG_FPMINIMAX_DID_NOT_CONVERGE                             , "Fpminimax did not converge" },
  { SOLLYA_MSG_FPMINIMAX_NOT_ENOUGH_POINTS                            , "Fpminimax has been called with no sufficient number of points" },
  { SOLLYA_MSG_FPMINIMAX_NOT_ENOUGH_FORMATS                           , "Fpminimax has been called with no sufficient number of formats" },
  { SOLLYA_MSG_FPMINIMAX_COMP_OF_MATRIX_ENTRY_USES_SLOWER_ALGO        , "Fpminimax: the computation of a certain matrix entry uses a slower algorithm" },
  { SOLLYA_MSG_DIFFERENTIATING_FOR_DECORRELATION                      , "Interval evaluation performs a formal differentiation in order to try to decorrelate expressions" },
  { SOLLYA_MSG_DECORRELATION_INTERVAL_ADDITION_OR_SUBTRACTION         , "Decorrelation is performed on an interval addition or subtraction" },
  { SOLLYA_MSG_DIFFERENTIATING_FOR_HOPITALS_RULE                      , "Interval evaluation performs a formal differentiation in order to use Hopital's rule" },
  { SOLLYA_MSG_USING_HOPITALS_RULE_ON_POINT_DIVISION                  , "Using Hopital's rule on point division" },
  { SOLLYA_MSG_SIMPLIFYING_INTERVAL_DIV_WITH_ZERO_POINT_NUMERA        , "Simplifying an interval division with a zero point interval as a numerator" },
  { SOLLYA_MSG_USING_HOPITALS_RULE_IN_GENERAL_CASE                    , "Using Hopital's rule in the general case" },
  { SOLLYA_MSG_RECURSION_ON_USE_OF_HOPITALS_RULE                      , "Recursion is needed on the use of Hopital's rule" },
  { SOLLYA_MSG_AVOIDING_TAYLOR_EVALUATION_ON_POINT_INTERVAL           , "Avoiding Taylor evaluation on a point interval" },
  { SOLLYA_MSG_NO_TAYLOR_EVALUATION_AS_NO_DERIVATIVE_GIVEN            , "No Taylor evaluation is possible because no derivative has been given" },
  { SOLLYA_MSG_USING_TAYLOR_EVALUATION                                , "Taylor evaluation gets used" },
  { SOLLYA_MSG_NO_TAYLOR_EVALUATION_AS_NO_DERIVATIVE_GETS_HUGE        , "No Taylor evaluation is possible because with all recursions, the tree of the derivative has become huge" },
  { SOLLYA_MSG_DERIVATIVE_DOES_NOT_CHANGE_SIGN_ON_TAYLOR_EVAL         , "The derivative of a function does not change sign on an interval during Taylor evaluation. The convex hull algorithm gets used" },
  { SOLLYA_MSG_NAN_OR_INF_ON_DERIVATIVE                               , "The tree for the derivative of a function evaluates to NaN or Inf on an interval. The function might not be differentiable" },
  { SOLLYA_MSG_INVOKING_RECURSIVE_INTERVAL_ZERO_SEARCH                , "Invoking recursive interval zero search" },
  { SOLLYA_MSG_RECURSIVE_INTERVAL_ZERO_SEARCH_HAS_FINISHED            , "Recursive interval zero search has finished" },
  { SOLLYA_MSG_CERTAIN_NUM_OF_INTVALS_ENCLOSING_ZEROS_OF_DERIV        , "A certain number of interval enclosing the zeros of the derivative of a function has been found" },
  { SOLLYA_MSG_EXPRESSION_IS_CONSTANT                                 , "The given expression is constant" },
  { SOLLYA_MSG_EVALUATION_AT_POINT_GIVES_NAN_EXCLUDING_POINT          , "The evaluation of a certain function at a certain point becomes NaN. The point gets excluded from the list of points yielding to the result" },
  { SOLLYA_MSG_THE_CURRENT_MAXIMUM_IS_A_CERTAIN_VALUE                 , "The current maximum is a certain value" },
  { SOLLYA_MSG_EVALUATION_OF_DERIVATIVE_GIVES_NAN_NO_NEWTON           , "The evaluation of the derivative of the function gives NaN. Newton's algorithm will not be used on this sub-interval" },
  { SOLLYA_MSG_NO_PROOF_WILL_BE_GENERATED                             , "No proof will be generated" },
  { SOLLYA_MSG_INFNORM_RESULT_IS_TRIVIAL                              , "The infnorm result of the given function on the given domain is trivially computable" },
  { SOLLYA_MSG_DERIVATIVE_IS_QUOTIENT                                 , "The derivative of the given function is a quotient" },
  { SOLLYA_MSG_DERIVATIVE_SEEMS_TO_HAVE_SINGULARITY                   , "The derivative of the given function seems to have a singularity in the domain" },
  { SOLLYA_MSG_DERIVATIVE_SEEMS_TO_HAVE_EXTENSIBLE_SINGULARITY        , "The derivative of the given function seems to have an extensible singularity in the domain" },
  { SOLLYA_MSG_DERIVATIVE_SEEMS_NOT_TO_HAVE_ANY_POLE                  , "The derivative of the given function seems not to have any pole in the domain" },
  { SOLLYA_MSG_INVOKING_INFNORM_SUBFUNCTION                           , "Invoking the infnorm subfunction" },
  { SOLLYA_MSG_INFNORM_SUBFUNCTION_HAS_FINISHED                       , "The infnorm subfunction has finished" },
  { SOLLYA_MSG_STARTING_TO_WRITE_THE_PROOF                            , "Starting to write the proof" },
  { SOLLYA_MSG_THE_PROOF_HAS_BEEN_WRITTEN                             , "The proof has been written" },
  { SOLLYA_MSG_THE_EXPRESSION_IS_NOT_CONSTANT                         , "The given expression is not constant. It will be evaluated at 1" },
  { SOLLYA_MSG_COULD_NOT_CHECK_INFNORM_ON_A_CERTAIN_INTERVAL          , "The given infinity norm result could not be checked on a certain (sub-)interval" },
  { SOLLYA_MSG_REMOVING_A_POSSIBLE_ZERO_AT_SOME_POINT                 , "A possible zero at some point is removed" },
  { SOLLYA_MSG_ZERO_FILTER_HAS_REMOVED_AT_LEAST_ONE_ZERO              , "The actual zero filter has removed at least one possible zero" },
  { SOLLYA_MSG_FAITHFUL_EVALUATION_RETURNS_NAN                        , "Faithful evaluation returns NaN" },
  { SOLLYA_MSG_INTERMEDIATE_PRECISION_HAS_BEEN_INCREASED              , "The intermediate precision has been increased to a certain value" },
  { SOLLYA_MSG_TAYLOR_RECURSION_TEMPORARILY_SET_TO_A_VALUE            , "The number of Taylor recursions has been temporarily set to a certain value" },
  { SOLLYA_MSG_ABS_DIAM_AND_PREC_SET_TO_CERTAIN_VALUES                , "The absolute diameter and the intermediate precision have been temporarily set to certain values" },
  { SOLLYA_MSG_IDENTIFIER_IS_LIBRARY_FUNC_CANNOT_BE_EXTERNAL          , "An identifier is already bound to a library function. It cannot be bound to an external procedure" },
  { SOLLYA_MSG_HANDLED_SIGSEGV                                        , "A SIGSEGV signal has been handled" },
  { SOLLYA_MSG_HANDLED_SIGBUS                                         , "A SIGBUS signal has been handled" },
  { SOLLYA_MSG_HANDLED_SIGFPE                                         , "A SIGFPE signal has been handled" },
  { SOLLYA_MSG_HANDLED_SIGPIPE                                        , "A SIGPIPE signal has been handled" },
  { SOLLYA_MSG_CANNOT_SUPPRESS_OR_UNSUPPRESS_A_MESSAGE                , "A message with a certain message number cannot be suppressed nor unsuppressed" },
  { SOLLYA_MSG_EXPR_DOES_NOT_EVALUATE_TO_INT_OR_LIST_OF_INT           , "A certain expression does not evaluate to a machine integer nor to a list of machine integers" },
  { SOLLYA_MSG_SUPPRESSION_NUMBER_OMITTED                             , "A certain message suppression or unsuppression command will have had no effect for a certain message number" },
  { SOLLYA_MSG_ROUNDING_ON_CONSTANT_RETRIEVAL                         , "A rounding occurred on retrieval of a constant" },
  { SOLLYA_MSG_MIN_RELIES_ON_FP_RESULT_FAITHFUL_BUT_NOT_REAL          , "A minimum computation relies on floating-point result that is faithfully evaluated and at least one of the terms is not a real number" },
  { SOLLYA_MSG_MAX_RELIES_ON_FP_RESULT_FAITHFUL_BUT_NOT_REAL          , "A maximum computation relies on floating-point result that is faithfully evaluated and at least one of the terms is not a real number" },
  { SOLLYA_MSG_EXPRESSION_EVALUATES_TO_INFINITY                       , "An expression evaluates to infinity" },
  { SOLLYA_MSG_DEG_OF_MAX_POLY_DIV_IS_NOT_CONSTANT                    , "An attempt was made to compute the degree of the maximal polynomial divider of a polynomial in an expression using a power operator with an exponent which is not a constant but a constant expression" },
  { SOLLYA_MSG_DEG_OF_MAX_POLY_DIV_IS_NOT_INTEGER                     , "An attempt was made to compute the degree of the maximal polynomial divider of a polynomial in an expression using a power operator with an exponent which is not an integer" },
  { SOLLYA_MSG_DEG_OF_MAX_POLY_DIV_IS_NEGATIVE                        , "An attempt was made to compute the degree of the maximal polynomial divider of a polynomial in an expression using a power operator with an exponent which is negative" },
  { SOLLYA_MSG_RATIONALAPPROX_SECOND_ARG_MUST_BE_GREATER_THAN_ONE     , "Error in rationalapprox: the second argument of rationalapprox must be greater or equal to 2" },
  { SOLLYA_MSG_ROUND_PREC_MUST_BE_AT_LEAST_TWO_BITS                   , "The precision specified when rounding to a particular format must be at least 2 bits" },
  { SOLLYA_MSG_NAN_CONVERTED_TO_NUMBER_ON_CONSTANT_RETRIEVAL          , "A Not-A-Number value has been converted to a number upon retrieval of a constant." },
  { SOLLYA_MSG_CHEBYSHEVFORM_DEGREE_MUST_NOT_BE_NEGATIVE              , "The degree of a Chebyshev form must be at least zero."},
  { SOLLYA_MSG_CHEBYSHEVFORM_DOMAIN_MUST_NOT_BE_POINT_INTERVAL        , "The domain of a Chebyshev Model can not be a point interval"},
  { SOLLYA_MSG_CHEBYSHEVFORM_ERROR_IN_COMPUTATION                     , "An error occurred during computation of a Chebyshev form."},
  { SOLLYA_MSG_ERROR_IN_CHEBYSHEVFORM_COPYING_INCOMPAT_MODELS         , "Error in Chebyshev form computation: copy of incompatible models."},
  { SOLLYA_MSG_ERROR_IN_CHEBYSHEVFORM_UNKNOWN_FUNC_FOR_ZUMKELLER      , "Error in Chebyshev form computation: unkown type of function used with Zumkeller's technique."},
  { SOLLYA_MSG_ERROR_IN_CHEBYSHEVFORM_NOT_A_POLYNOMIAL                , "Error in Chebyshev form computation: the given function is not a polynomial, no modification is made." },  
  { SOLLYA_MSG_SPECIAL_ALGORITHM_USED_FOR_COEFF                       , "A special algorithm is used to extract the i-th coefficient of an expression that is a polynomial." },
  { SOLLYA_MSG_NO_CORRECT_ROUNDING_FOR_ROUND_OPERATOR                 , "No correctly rounded result could be obtained upon evaluation of a rounding operator." },
  { SOLLYA_MSG_ROUNDING_OF_BOUNDARY_INSTEAD_OF_CORRECT_ROUNDING       , "The returned rounding is the rounding of the rounding boundary because correct rounding has not been possible." },
  { SOLLYA_MSG_NO_CORRECT_TERNARY_VALUE_FOR_ROUND_BUT_CORRECT_ROUNDING, "A correct rounding was possible but the actual rounding direction could not be determined." },
  { SOLLYA_MSG_NO_CORRECT_TERNARY_VALUE_FOR_ROUND                     , "The actual rounding direction during a round operation could not be determined." },
  /* Add your new warning message texts above here. */

  { -1, "Unknown message number -1" }   /* Do not ever change the text in this default entry, which must be the last entry in the list */
};
#endif


/* Declaration of the function translating message numbers to texts */
char *messageNumberToText(int);
int messageNumberExists(int);
int getMessageId(sollya_msg_t);

#endif /* ifdef SOLLYA_MESSAGING_H*/
