#include "petsc.h"
#include "myCreateVec.h"

int main(int argc, char **argv){
  Vec x1, x2;
  PetscScalar res;
  int n=10000;

  PetscInitialize(&argc, &argv, NULL, NULL);
  
  create1(&x1, n);
  create2(&x2, n);
  VecDot(x1, x2, &res);

  PetscPrintf(PETSC_COMM_SELF, "dot product: %e\n", res);

  VecDestroy(&x1);
  VecDestroy(&x2);
  PetscFinalize();
  return 0;
}
