      program AXPY
      implicit none

#include <finclude/petsc.h>

      Vec x, y
      PetscScalar alpha 
      PetscErrorCode ierr
      integer i, n, rep
      
      n=10000
      rep=100
      alpha = 1.

      call PetscInitialize(PETSC_NULL_CHARACTER, ierr)
           CHKERRQ(ierr)

      call PetscOptionsGetInt(PETSC_NULL_CHARACTER, "-n", n, 
     &                        PETSC_NULL_CHARACTER, ierr)
 
      call VecCreateMPI(PETSC_COMM_WORLD, PETSC_DECIDE, n, x, ierr)
      call VecDuplicate(x, y, ierr)

      call VecSet(x, 1., ierr)
      call VecSet(y, 2., ierr)

      do i=0,rep
         call VecAXPY(y, alpha, x, ierr)
      end do

      call VecDestroy(x, ierr)
      call VecDestroy(y, ierr)
      call PetscFinalize(ierr)
      end program AXPY
