#include "petsc.h"

#undef __FUNCT__
#define __FUNCT__ "main"
int main(int argc, char **argv){
  Vec x, y;
  PetscScalar alpha = 1.;
  PetscErrorCode ierr;
  int i, n=10000, rep=100;
  Mat A;
  
  ierr = PetscInitialize(&argc, &argv, NULL, NULL);CHKERRQ(ierr);

  ierr = PetscOptionsGetInt(PETSC_NULL, "-n", &n, PETSC_NULL);CHKERRQ(ierr);
 
  ierr = MatCreate(PETSC_COMM_SELF, &A);
  ierr = MatSetSizes(A, 100, 100, PETSC_DECIDE, PETSC_DECIDE);
  ierr = MatSetType(A, MATAIJ);
  ierr = MatSetFromOptions(A);
  ierr = MatSetUp(A);
  i = 1;
  MatSetValues(A, 1, &i, 1, &i, &alpha, INSERT_VALUES);
  ierr = MatAssemblyBegin(A,MAT_FINAL_ASSEMBLY);CHKERRQ(ierr);
  ierr = MatAssemblyEnd(A,MAT_FINAL_ASSEMBLY);CHKERRQ(ierr);


  ierr = VecCreateMPI(PETSC_COMM_WORLD, PETSC_DECIDE, n, &x);CHKERRQ(ierr);
  ierr = VecDuplicate(x, &y);CHKERRQ(ierr);

  ierr = VecSet(x, 1.);CHKERRQ(ierr);
  ierr = VecSet(y, 2.);CHKERRQ(ierr);

  for (i=0; i<rep; i++){
    ierr = VecAXPY(y, alpha, x);CHKERRQ(ierr);
  }

  ierr = VecDestroy(&x);CHKERRQ(ierr);
  ierr = VecDestroy(&y);CHKERRQ(ierr);
  ierr = MatDestroy(&A);CHKERRQ(ierr);
  ierr = PetscFinalize();
  return 0;
}
