#include <stdint.h>
#include <gmp.h>
#include <mpfr.h>

typedef union {
  uint64_t l;
  double d;
} xdb_t;

#define INLINE   inline
#define RESTRICT restrict
#define STATIC   static

STATIC INLINE void decomposeDouble(int * RESTRICT sign, int * RESTRICT exponent, double * RESTRICT mantissa, double x) {
  xdb_t xdb;
  int E;

  xdb.d = x;
  *sign = !!(xdb.l >> 63);

  xdb.l &= 0x7fffffffffffffffull;

  if (xdb.l == 0x0ull) {
    *exponent = 0;
    *mantissa = 0.0;
    return;
  }

  E = 0;
  if (xdb.l < 0x0010000000000000ull) {
    xdb.d *= 9007199254740992.0;
    E -= 53;
  }

  E += ((int) (xdb.l >> 52)) - 1023;

  *exponent = E;

  xdb.l = (xdb.l & 0x000fffffffffffffull) | 0x3ff0000000000000ull;

  *mantissa = xdb.d;
}

STATIC INLINE int doubleIsNaN(double x) {
  xdb_t xdb;

  xdb.d = x;

  return ((xdb.l & 0x7fffffffffffffffull) > 0x7ff0000000000000ull);
}

STATIC INLINE int doubleIsInf(double x) {
  xdb_t xdb;

  xdb.d = x;

  return ((xdb.l & 0x7fffffffffffffffull) == 0x7ff0000000000000ull);
}

STATIC INLINE int doubleIsSignPositive(double x) {
  xdb_t xdb;

  xdb.d = x;

  return !(xdb.l >> 63);
}

STATIC INLINE double giveNaNDouble() {
  volatile double a, b;

  a = 0.0;
  b = 0.0;
  
  return a / b;
}

STATIC INLINE double giveInfDouble(int sign) {
  volatile double a, b;

  if (sign) a = -1.0; else a = 1.0;
  b = 0.0;
  b = b * b;

  return (a / b);
}

STATIC INLINE void cutDouble(double * RESTRICT xh, double * RESTRICT xl, double x) {
  xdb_t xdb;
  double high;

  xdb.d = x;

  xdb.l &= ~(((uint64_t) 1 << 32) - ((uint64_t) 1));
  
  high = xdb.d;

  *xh = high;
  *xl = x - high;
}


double mylog2(double x);

// A binding for Sollya externalplot
//
void f(mpfr_t rop, mpfr_t op) {
  double x, y;
  x = mpfr_get_d(op,GMP_RNDN);
  y = mylog2(x);
  mpfr_set_d(rop, y, GMP_RNDN);
}
