#!/bin/bash
#@ class            = clallmds
#@ job_name         = hydro_test_$(total_tasks)prc
#@ total_tasks      = 16
#@ node             = 1
#@ wall_clock_limit = 1:00:00
#@ output           = $(job_name).$(jobid)
#@ error            = $(job_name).$(jobid)
#@ job_type         = mpich
#@ queue

#set -x

##############
# Parameters #
##############
#HYDRO version (C or F90)
HLANG=C

#Problem size
#For one output: 250=2MB , 1000=32MB, 10000=3.2GB, 20000=12.8GB
#(each run performs 10 outputs)
NX=10000

#Fileformat
#Possible values: std, adios, hdf5, mpiio, netcdf, pnetcdf
# On poincare: std, hdf5, mpiio, pnetcdf, (netcdf)
FILEFORMAT=std


####################
# Other parameters #
####################
#Warning: do not change them!
#WKDIR=$HOME/tp_HYDRO
WKDIR=..
NSTEPMAX=$(( 10000000000 / ( $NX * $NX ) ))
NSTEPMAX=$(echo $(($NSTEPMAX>10?$NSTEPMAX:10)))
NSTEPMAXST=$(( $NSTEPMAX / 2 ))
NOUTPUT=$(( $NSTEPMAX / 10 ))
NY=$NX
DX=$(echo "scale=7; 1 / 10000" | bc)
if [ "$HLANG" = "C" ]; then
  PRE="-i"
fi
if [ "$FILEFORMAT" = "std" ]; then
  RESTARTFILE="output_00005"
elif [ "$FILEFORMAT" = "adios" ]; then
  RESTARTFILE="output_00005.ad"
elif [ "$FILEFORMAT" = "hdf5" ]; then
  RESTARTFILE="output_00005.h5"
elif [ "$FILEFORMAT" = "mpiio" ]; then
  RESTARTFILE="output_00005.mp"
elif [ "$FILEFORMAT" = "netcdf" ]; then
  RESTARTFILE="output_00005.nc4"
elif [ "$FILEFORMAT" = "pnetcdf" ]; then
  RESTARTFILE="output_00005.nc"
fi

###############
# Prepare run #
###############
sed -e "s/NSTEPMAX/$(( $NSTEPMAX / 2 ))/g" -e "s/NOUTPUT/$NOUTPUT/g" -e "s/NX/$NX/g" -e "s/NY/$NY/g" -e "s/DX/$DX/g" -e "s/FILEFORMAT/$FILEFORMAT/g" $WKDIR/Input/input_sedov_start_generic.nml > input_start.nml

sed -e "s/NSTEPMAX/$NSTEPMAX/g" -e "s/NOUTPUT/$NOUTPUT/g" -e "s/NX/$NX/g" -e "s/NY/$NY/g" -e "s/DX/$DX/g" -e "s/FILEFORMAT/$FILEFORMAT/g" -e "s/RESTARTFILE/$RESTARTFILE/g" $WKDIR/Input/input_sedov_restart_generic.nml > input_restart.nml


module load intel intelmpi
module load hdf5/1.8.10_intel13_intelmpi netcdf4/4.2_intel_intelmpi pnetcdf/1.3.1_intel_intelmpi

date


#################
# Execute HYDRO #
#################

mpirun $WKDIR/$HLANG/hydro $PRE input_start.nml

mpirun $WKDIR/$HLANG/hydro $PRE input_restart.nml


#######################
# Remove output files #
#######################
rm -f output_*


