/*
*  C Implementation: mpi_funcs
*
* Description: MPI functions used by HYDRO MPI2D
*
*
* Author: Philippe Wautelet <philippe.wautelet@idris.fr>, (C) 2010
*
*/

#ifndef MPI_FUNCS_H_INCLUDED
#define MPI_FUNCS_H_INCLUDED

#include "mpi.h"


#define WEST 0
#define EAST 1
#define SOUTH 2
#define NORTH 3

struct _mpi_vars {
  int nb_procs; // Number of processes
  int rank;     // Rank of the process in the comm2d communicator

  int neighb[4]; // Neighbor list

  MPI_Comm comm2d; // Cartesian 2D-topology communicator

  MPI_Datatype bloc_dim1; // Derived datatype for west/east communications
  MPI_Datatype bloc_dim2; // Derived datatype for north/south communications
} mpi_vars;




void init_mpi(int *argc, char ***argv, hydroparam_t * H);

void clean_mpi();

#endif // MPI_FUNCS_H_INCLUDED
