/*
*  C Implementation: mpi_funcs
*
* Description: main header
*
*
* Author: Philippe Wautelet <philippe.wautelet@idris.fr>, (C) 2010
*
*/

#ifndef MAIN_H_INCLUDED
#define MAIN_H_INCLUDED

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "parametres.h"
#include "mpi_funcs.h"

#include "cmpflx.h"
#include "compute_deltat.h"
#include "conservar.h"
#include "constoprim.h"
#include "equation_of_state.h"
#include "hydro_funcs.h"
#include "hydro_godunov.h"
#include "io.h"
#include "make_boundary.h"
#include "qleftright.h"
#include "riemann.h"
#include "slope.h"
#include "trace.h"
#include "utils.h"
#include "vtkfile.h"

hydroparam_t H;
hydrovar_t Hv;                  // nvar
hydrovarwork_t Hvw;             // nvar
hydrowork_t Hw;

static unsigned long flops=0;

#endif // MAIN_H_INCLUDED
