#ifndef OUTPUT_H_INCLUDED
#define OUTPUT_H_INCLUDED

void output(int step, const hydroparam_t H, hydrovar_t * Hv);
void input(int*, hydroparam_t *, hydrovar_t *);

void output_std(int, const hydroparam_t, hydrovar_t *);
void input_std(hydroparam_t *H, hydrovar_t * Hv);

void print_io_versions();
void timer_start();
void timer_stop(char *filetype, int writing,unsigned long size);

#define READING 0
#define WRITING 1


#ifdef ADIOS
void output_adios(int, const hydroparam_t, hydrovar_t *);
void input_adios(hydroparam_t *H, hydrovar_t * Hv);
void check_adios_write_initialization();
void clean_adios_write();
#endif

#ifdef HDF5
void output_hdf5(int, const hydroparam_t, hydrovar_t *);
void input_hdf5(hydroparam_t *H, hydrovar_t * Hv);
void check_hdf5_initialization();
void clean_hdf5();
#endif

#ifdef MPIIO
void output_mpiio(int, const hydroparam_t, hydrovar_t *);
void input_mpiio(hydroparam_t *H, hydrovar_t * Hv);
#endif

#ifdef NETCDF4
void output_netcdf(int, const hydroparam_t, hydrovar_t *);
void input_netcdf(hydroparam_t *H, hydrovar_t * Hv);
#endif

#ifdef PNETCDF
void output_pnetcdf(int, const hydroparam_t, hydrovar_t *);
void input_pnetcdf(hydroparam_t *H, hydrovar_t * Hv);
#endif

#ifdef SIONLIB
void output_sionlib(int, const hydroparam_t, hydrovar_t *);
void input_sionlib(hydroparam_t *H, hydrovar_t * Hv);
#endif

#endif // OUTPUT_H_INCLUDED
