program ex4
  implicit none
#include "finclude/petsc.h"
  PetscErrorCode :: ierr
  Vec :: theVecMPI, theVecSeq
  integer :: i, MPIrank, MPIsize, istart, iend, localSize, ii
  integer, parameter :: totalSize = 100
  integer :: indices(3)
  integer, dimension(:), allocatable :: theIndices
  PetscScalar, dimension(:), allocatable :: theValues
  IS :: is1,is2
  VecScatter :: ctx
 
  call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
  call MPI_Comm_rank(PETSC_COMM_WORLD, MPIrank,ierr)
  call MPI_Comm_size(PETSC_COMM_WORLD, MPIsize,ierr)
!
  call VecCreateMPI(PETSC_COMM_WORLD,PETSC_DECIDE,totalSize,theVecMPI,ierr)
  call VecGetOwnershipRange(theVecMPI, istart, iend, ierr)
  localSize = iend - istart
  allocate(theIndices(localSize))
  allocate(theValues(localSize))
  ii = 1
  do 10 i=istart, iend-1
    theIndices(ii) = i
    theValues(ii) = i
    ii = ii+1
  10 continue
  call VecSetValues(theVecMPI,localSize,theIndices,theValues,INSERT_VALUES,ierr)
  call VecAssemblyBegin(theVecMPI,ierr)
  call VecAssemblyEnd(theVecMPI,ierr)
! call VecView(theVecMPI,PETSC_VIEWER_STDOUT_WORLD,ierr)
!
! call VecCreateSeq(PETSC_COMM_SELF,theVecSeq,3,ierr)
  call VecCreate(PETSC_COMM_SELF,theVecSeq,ierr)
  call VecSetType(theVecSeq, VECSEQ,ierr)
  call VecSetSizes(theVecSeq, 3, 3,ierr)
!
  indices(1) = 6
  indices(2) = 45
  indices(3) = 97
  call ISCreateGeneral(PETSC_COMM_WORLD,3,indices,PETSC_COPY_VALUES,is1,ierr)
! call ISView(is1,PETSC_VIEWER_STDOUT_WORLD,ierr)

  call ISCreateStride(PETSC_COMM_SELF,3,0,1,is2,ierr)
! call ISView(is2,PETSC_VIEWER_STDOUT_SELF,ierr)

  call VecScatterCreate(theVecMPI,is1,theVecSeq,is2,ctx,ierr)
  call VecScatterBegin(ctx,theVecMPI,theVecSeq,INSERT_VALUES,SCATTER_FORWARD,ierr)
  call VecScatterEnd(ctx,theVecMPI,theVecSeq,INSERT_VALUES,SCATTER_FORWARD,ierr)
  call VecView(theVecSeq,PETSC_VIEWER_STDOUT_SELF,ierr)

  call VecDestroy(theVecMPI,ierr)
  call VecDestroy(theVecSeq,ierr)
  call ISDestroy(is1,ierr)
  call ISDestroy(is2,ierr)
  call VecScatterDestroy(theVecSeq,ierr)
  call PetscFinalize(ierr)
end program ex4
