#include "petscvec.h"
int main(int argc, char **argv){
  Vec theVecMPI, theVecSeq;
  int i, MPIrank, MPIsize, istart, iend, localSize, ii;
  const int totalSize = 100;
  int indices[3];
  IS is1,is2;
  VecScatter ctx;

  PetscInitialize(&argc, &argv, NULL, NULL);
  MPI_Comm_rank(PETSC_COMM_WORLD, &MPIrank);
  MPI_Comm_size(PETSC_COMM_WORLD, &MPIsize);

  VecCreate(PETSC_COMM_WORLD,&theVecMPI);
  VecSetType(theVecMPI, VECMPI);
  VecSetSizes(theVecMPI, PETSC_DECIDE, totalSize);
  VecGetOwnershipRange(theVecMPI,&istart,&iend);
  localSize = iend - istart;

  int* theIndices = malloc(localSize*sizeof(int));
  PetscScalar* theValues = malloc(localSize*sizeof(PetscScalar));
  ii = 0;
  for (i=istart; i<iend; ++i){
    theIndices[ii] = i;
    theValues[ii] = (PetscScalar) i;
    ++ii;
  }
  VecSetValues(theVecMPI,localSize,theIndices,theValues,INSERT_VALUES);
  VecAssemblyBegin(theVecMPI);
  VecAssemblyEnd(theVecMPI);
//VecView(theVec,PETSC_VIEWER_STDOUT_WORLD);
   
//VecCreateSeq(PETSC_COMM_SELF,theVecSeq,3)
  VecCreate(PETSC_COMM_SELF,&theVecSeq);
  VecSetType(theVecSeq, VECSEQ);
  VecSetSizes(theVecSeq, 3, 3);

  indices[0] = 6;
  indices[1] = 45;
  indices[2] = 97;
  ISCreateGeneral(PETSC_COMM_WORLD,3,indices,PETSC_COPY_VALUES,&is1);
//ISView(is1,PETSC_VIEWER_STDOUT_WORLD)
  ISCreateStride(PETSC_COMM_SELF,3,0,1,&is2);
//ISView(is2,PETSC_VIEWER_STDOUT_SELF);
  VecScatterCreate(theVecMPI,is1,theVecSeq,is2,&ctx);
  VecScatterBegin(ctx,theVecMPI,theVecSeq,INSERT_VALUES,SCATTER_FORWARD);
  VecScatterEnd(ctx,theVecMPI,theVecSeq,INSERT_VALUES,SCATTER_FORWARD);
  VecView(theVecSeq,PETSC_VIEWER_STDOUT_SELF);

  VecDestroy(&theVecSeq);
  VecDestroy(&theVecMPI);
  ISDestroy(&is1);
  ISDestroy(&is2);
  VecScatterDestroy(&ctx);
  PetscFinalize();
  return 0;
}

