program ex3_b
  implicit none
#include "finclude/petsc.h"
  PetscErrorCode :: ierr
  Vec :: theVec
  integer :: i, MPIrank, MPIsize, istart, iend, localSize, ii
  integer, parameter :: totalSize = 100000000
! integer, parameter :: totalSize = 10
  integer, dimension(:), allocatable :: theIndices
  PetscScalar, dimension(:), allocatable :: theValues
!
  call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
  call MPI_Comm_rank(PETSC_COMM_WORLD, MPIrank,ierr)
  call MPI_Comm_size(PETSC_COMM_WORLD, MPIsize,ierr)

  call VecCreate(PETSC_COMM_WORLD,theVec,ierr)
  call VecSetType(theVec, VECMPI,ierr)
  call VecSetSizes(theVec, PETSC_DECIDE, totalSize, ierr)
!
  call VecGetOwnershipRange(theVec, istart, iend, ierr)
  localSize = iend - istart
  allocate(theIndices(localSize))
  allocate(theValues(localSize))
!
  ii = 1
  do 10 i=istart, iend-1
    theIndices(ii) = i
    theValues(ii) = i
    ii = ii+1
  10 continue
  call VecSetValues(theVec,localSize,theIndices,theValues,INSERT_VALUES,ierr)
!
  call VecAssemblyBegin(theVec,ierr)
  call VecAssemblyEnd(theVec,ierr)
! call VecView(theVec,PETSC_VIEWER_STDOUT_WORLD,ierr)
  call VecDestroy(theVec,ierr)
  call PetscFinalize(ierr)
end program ex3_b
