#include "petscvec.h"
int main(int argc, char **argv){
  Vec theVec;
  int i, MPIrank, MPIsize, istart, iend, localSize, ii;
  const int totalSize = 100000000;
//const int totalSize = 10;

  PetscInitialize(&argc, &argv, NULL, NULL);
  MPI_Comm_rank(PETSC_COMM_WORLD, &MPIrank);
  MPI_Comm_size(PETSC_COMM_WORLD, &MPIsize);

  VecCreate(PETSC_COMM_WORLD,&theVec);
  VecSetType(theVec, VECMPI);
  VecSetSizes(theVec, PETSC_DECIDE, totalSize);
  VecGetOwnershipRange(theVec,&istart,&iend);
  localSize = iend - istart;

  int* theIndices = malloc(localSize*sizeof(int));
  PetscScalar* theValues = malloc(localSize*sizeof(PetscScalar));
  ii = 0;
  for (i=istart; i<iend; ++i){
    theIndices[ii] = i;
    theValues[ii] = (PetscScalar) i;
    ++ii;
  }
  VecSetValues(theVec,localSize,theIndices,theValues,INSERT_VALUES);
  VecAssemblyBegin(theVec);
  VecAssemblyEnd(theVec);
//VecView(theVec,PETSC_VIEWER_STDOUT_WORLD);
  VecDestroy(&theVec);
  PetscFinalize();
  return 0;
}
