program ex3_a
  implicit none
#include "finclude/petsc.h"
  PetscErrorCode :: ierr
  Vec :: theVec
  PetscScalar :: theValue
  integer :: i, MPIrank, MPIsize, istart, iend
  integer, parameter :: totalSize = 100000000
  call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
  call MPI_Comm_rank(PETSC_COMM_WORLD, MPIrank,ierr)
  call MPI_Comm_size(PETSC_COMM_WORLD, MPIsize,ierr)

  call VecCreate(PETSC_COMM_WORLD,theVec,ierr)
  call VecSetType(theVec, VECMPI,ierr)
  call VecSetSizes(theVec, PETSC_DECIDE, totalSize, ierr)
!
  call VecGetOwnershipRange(theVec, istart, iend, ierr)
  do 10 i=istart, iend-1
    theValue = i
    call VecSetValue(theVec,i,theValue,INSERT_VALUES,ierr)
  10 continue
!
  call VecAssemblyBegin(theVec,ierr)
  call VecAssemblyEnd(theVec,ierr)
! call VecView(theVec,PETSC_VIEWER_STDOUT_WORLD,ierr)
  call VecDestroy(theVec,ierr)
  call PetscFinalize(ierr)
end program ex3_a
