#include "petscvec.h"
int main(int argc, char **argv){
  Vec theVec;
  PetscScalar theValue;
  int i, MPIrank, MPIsize, istart, iend;
  const int totalSize = 100000000;
  PetscInitialize(&argc, &argv, NULL, NULL);
  MPI_Comm_rank(PETSC_COMM_WORLD, &MPIrank);
  MPI_Comm_size(PETSC_COMM_WORLD, &MPIsize);

  VecCreate(PETSC_COMM_WORLD,&theVec);
  VecSetType(theVec, VECMPI);
  VecSetSizes(theVec, PETSC_DECIDE, totalSize);
  VecGetOwnershipRange(theVec,&istart,&iend);
  for (i=istart; i<iend; ++i){
    theValue = i;
    VecSetValue(theVec,i,theValue,INSERT_VALUES);
  }
  VecAssemblyBegin(theVec);
  VecAssemblyEnd(theVec);
// VecView(theVec,PETSC_VIEWER_STDOUT_WORLD);
  VecDestroy(&theVec);
  PetscFinalize();
  return 0;
}
