#include "petscvec.h"
int main(int argc, char **argv){
  Vec theVec, theVecCopy;
  int i, MPIrank, MPIsize, localSize;
  PetscScalar theValue, theDotProduct, theNorm;
  PetscInitialize(&argc, &argv, NULL, NULL);
  MPI_Comm_rank(PETSC_COMM_WORLD, &MPIrank);
  MPI_Comm_size(PETSC_COMM_WORLD, &MPIsize);

  VecCreate(PETSC_COMM_WORLD,&theVec);
  VecSetType(theVec, VECMPI);
  localSize = MPIrank+1;
  VecSetSizes(theVec, localSize, PETSC_DETERMINE);
  theValue = 0.5*MPIsize;
  VecSet(theVec,theValue);
  VecAssemblyBegin(theVec);
  VecAssemblyEnd(theVec);
  VecView(theVec,PETSC_VIEWER_STDOUT_WORLD);

  VecDuplicate(theVec,&theVecCopy);
  VecCopy(theVec,theVecCopy);
  VecDot(theVec,theVecCopy,&theDotProduct);
  PetscPrintf(PETSC_COMM_WORLD,"theDotProduct = %G \n",theDotProduct);
  VecNorm(theVec,NORM_2,&theNorm);
  PetscPrintf(PETSC_COMM_WORLD,"theNorm^2 = %G \n",theNorm*theNorm);

  VecDestroy(&theVec);
  VecDestroy(&theVecCopy);
  PetscFinalize();
  return 0;
}
