program ex1
  implicit none
#include "finclude/petsc.h"
  PetscErrorCode :: ierr
  Vec :: theVec
  integer :: i, MPIrank, MPIsize, localSize
  PetscScalar :: theValue
  call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
  call MPI_Comm_rank(PETSC_COMM_WORLD, MPIrank,ierr)
  call MPI_Comm_size(PETSC_COMM_WORLD, MPIsize,ierr)

  call VecCreate(PETSC_COMM_WORLD,theVec,ierr)
  call VecSetType(theVec, VECMPI,ierr)
  localSize = MPIrank+1
  call VecSetSizes(theVec, localSize, PETSC_DETERMINE,ierr)
  theValue = 0.5*MPIsize
  call VecSet(theVec,theValue,ierr)
  call VecAssemblyBegin(theVec,ierr)
  call VecAssemblyEnd(theVec,ierr)
  call VecView(theVec,PETSC_VIEWER_STDOUT_WORLD,ierr)
  call VecDestroy(theVec,ierr)
  call PetscFinalize(ierr)
end program ex1
