#include "petscvec.h"
int main(int argc, char **argv){
  Vec theVec;
  int i, MPIrank, MPIsize, localSize;
  PetscScalar theValue;
  PetscInitialize(&argc, &argv, NULL, NULL);
  MPI_Comm_rank(PETSC_COMM_WORLD, &MPIrank);
  MPI_Comm_size(PETSC_COMM_WORLD, &MPIsize);

  VecCreate(PETSC_COMM_WORLD,&theVec);
  VecSetType(theVec, VECMPI);
  localSize = MPIrank+1;
  VecSetSizes(theVec, localSize, PETSC_DETERMINE);
  theValue = 0.5*MPIsize;
  VecSet(theVec,theValue);
  VecAssemblyBegin(theVec);
  VecAssemblyEnd(theVec);
  VecView(theVec,PETSC_VIEWER_STDOUT_WORLD);
  VecDestroy(&theVec);
  PetscFinalize();
  return 0;
}
