      program testFortran
      implicit none

#include <finclude/petsc.h>
      
      PetscErrorCode ierr
      Vec x1, x2
      PetscScalar res
      PetscBool flg

      integer n

      n=10000

      call PetscInitialize(PETSC_NULL_CHARACTER, ierr)
      CHKERRQ(ierr)

      call PetscOptionsGetInt(PETSC_NULL_CHARACTER, "-n", n,
     &     flg, ierr)
      CHKERRQ(ierr)

      call create1(x1, n, ierr)
      CHKERRQ(ierr)
      call create2(x2, n, ierr)
      CHKERRQ(ierr)

      call VecDot(x1, x2, res, ierr)
      print*, "dot product", res

      call PetscOptionsHasName(PETSC_NULL_CHARACTER, "-x1_view", 
     &     flg, ierr)
      CHKERRQ(ierr)
      if (flg) then
         call VecView(x1, PETSC_VIEWER_STDOUT_SELF, ierr)
         CHKERRQ(ierr)
      end if

      call PetscOptionsHasName(PETSC_NULL_CHARACTER, "-x2_view", 
     &     flg, ierr)
      CHKERRQ(ierr)
      if (flg) then
         call VecView(x2, PETSC_VIEWER_STDOUT_SELF, ierr)
         CHKERRQ(ierr)
      end if

      call VecDestroy(x1, ierr) 
      CHKERRQ(ierr)
      call VecDestroy(x2, ierr)
      CHKERRQ(ierr)

      call PetscFinalize(ierr)
      end program testFortran
