#include "petsc.h"
#include "myCreateVec.h"

#undef __FUNCT__
#define __FUNCT__ "main"
int main(int argc, char **argv){
  Vec x1, x2;
  PetscScalar res;
  PetscErrorCode ierr;
  PetscBool flg;

  int n=10000;

  ierr = PetscInitialize(&argc, &argv, NULL, NULL);CHKERRQ(ierr);

  ierr = PetscOptionsGetInt(PETSC_NULL, "-n", &n, PETSC_NULL);CHKERRQ(ierr);
 
  ierr = create1(&x1, n);CHKERRQ(ierr);
  ierr = create2(&x2, n);CHKERRQ(ierr);
  ierr = VecDot(x1, x2, &res);CHKERRQ(ierr);

  PetscPrintf(PETSC_COMM_SELF, "dot product: %e\n", res);

  ierr = PetscOptionsHasName(PETSC_NULL, "-x1_view", &flg);CHKERRQ(ierr);
  if (flg){
    ierr = VecView(x1, PETSC_VIEWER_STDOUT_SELF);CHKERRQ(ierr);
  }
  ierr = PetscOptionsHasName(PETSC_NULL, "-x2_view", &flg);CHKERRQ(ierr);
  if (flg){
    ierr = VecView(x2, PETSC_VIEWER_STDOUT_SELF);CHKERRQ(ierr);
  }

  ierr = VecDestroy(&x1);CHKERRQ(ierr);
  ierr = VecDestroy(&x2);CHKERRQ(ierr);
  ierr = PetscFinalize();
  return 0;
}
