#include "petsc.h"
#include "myCreateVec.h"

#undef __FUNCT__
#define __FUNCT__ "function1"
PetscErrorCode function1(Vec x, int n){
  int i;
  PetscErrorCode ierr;
  PetscFunctionBegin;
  for(i=0; i<n; i++){
    ierr = VecSetValue(x, i+10, i, INSERT_VALUES);CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
}

#undef __FUNCT__
#define __FUNCT__ "create1"
PetscErrorCode create1(Vec *x, int n){
  PetscErrorCode ierr;
  PetscFunctionBegin;
  ierr = VecCreateSeq(PETSC_COMM_SELF, n, x);CHKERRQ(ierr);
  ierr = VecSet(*x, 1.);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}

#undef __FUNCT__
#define __FUNCT__ "create2"
PetscErrorCode create2(Vec *x, int n){
  PetscErrorCode ierr;
  PetscFunctionBegin;  
  ierr = VecCreateSeq(PETSC_COMM_SELF, n, x);CHKERRQ(ierr);
  ierr = function1(*x, n);CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
