# Demonstration script for vtkpython v8
# written by Jean M. Favre, Swiss National Supercomputing Centre
# tested Fri Dec  1 09:01:26 CET 2017
#
# similar to ImageDataPipeline1.py but with an isosurface contour

import vtk
import numpy as np
from vtk.numpy_interface import dataset_adapter as dsa

iD = vtk.vtkImageData()
dims = [31,31,31]
iD.SetSpacing(1., 1., 1.)
iD.SetOrigin(0, 0, 0)
iD.SetDimensions(dims)

xaxis = np.linspace(-.5, 1., dims[0])
yaxis = np.linspace(-1., 1., dims[1])
zaxis = np.linspace(-1., .5, dims[2])
[xc,yc,zc] = np.meshgrid(zaxis,yaxis,xaxis, indexing="ij")
data = np.sqrt(xc**2 + yc**2 + zc**2)

image = dsa.WrapDataObject(iD)
image.PointData.append(data.ravel(), "scalar")

contour = vtk.vtkContourFilter()
contour.SetInputData(iD)
contour.SetValue(0, 1.0)
contour.SetInputArrayToProcess(0, 0, 0, 0, "scalar")

lut = vtk.vtkLookupTable()
lut.SetNumberOfTableValues(6)
lut.SetHueRange(0.6667,0)
lut.SetSaturationRange(1,1)
lut.SetValueRange(1,1)
lut.SetTableRange(0.0, np.sqrt(3.))
lut.Build()

m = vtk.vtkPolyDataMapper()
#m.SetInputConnection(geom.GetOutputPort())
m.SetInputConnection(contour.GetOutputPort())
m.UseLookupTableScalarRangeOn()
m.SetLookupTable(lut)
m.SelectColorArray("scalar")
m.SetColorModeToMapScalars()
m.ScalarVisibilityOn()
m.SetScalarModeToUsePointFieldData()

a = vtk.vtkActor()
a.SetMapper(m)
a.GetProperty().EdgeVisibilityOn()

ren = vtk.vtkRenderer()
ren.AddActor(a)

renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
renWin.SetSize(600, 600)

iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
iren.Initialize()
renWin.Render()
iren.Start()


