# Demonstration script for vtkpython v8
# written by Jean M. Favre, Swiss National Supercomputing Centre
# tested Fri Dec  1 09:01:26 CET 2017
#
# 

import vtk
import numpy as np
from vtk.numpy_interface import dataset_adapter as dsa

iD = vtk.vtkImageData()
dims = [31,31,31]
iD.SetSpacing(1., 1., 1.)
iD.SetOrigin(0, 0, 0)
iD.SetDimensions(dims)

xaxis = np.linspace(-.5, 1., dims[0])
yaxis = np.linspace(-1., 1., dims[1])
zaxis = np.linspace(-1., .5, dims[2])
[xc,yc,zc] = np.meshgrid(zaxis,yaxis,xaxis, indexing="ij")
data = np.sqrt(xc**2 + yc**2 + zc**2)

image = dsa.WrapDataObject(iD)
image.PointData.append(data.ravel(), "scalar")

geom = vtk.vtkGeometryFilter()
geom.SetInputData(iD)

m = vtk.vtkPolyDataMapper()
m.SetInputConnection(geom.GetOutputPort())

a = vtk.vtkActor()
a.SetMapper(m)
a.GetProperty().EdgeVisibilityOn()

ren = vtk.vtkRenderer()
ren.AddActor(a)

renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
renWin.SetSize(600, 600)

iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
iren.Initialize()
renWin.Render()
iren.Start()


