! A parallel Jacobi solver for the Laplacian equation in 2D
! Written by Jean M. Favre, Swiss National Supercomputing Center
! Sun Oct 31 2010
! Code inspired from an older example by Kadin Tseng, Boston University, November 1999
! The compile flag -D_VISIT_ enables compilation with VisIt. Otherwise, the pogram runs
! in stand-alone mode

program Jacobi
use jacobi_module
implicit none

#ifdef USE_CATALYST
    character(len=64) :: coproc_file
#endif



  call InitMPI()

#ifdef USE_CATALYST
    coproc_file = "coproc.py"
    if (iargc() == 1) then
      call getarg(1, coproc_file)
    end if
    call coprocessorinitializewithpython(trim(coproc_file), len_trim(coproc_file))
#endif

  m = 20 ! mesh size = (m+2)x(m+2) including the bc grid lines
! We make no attempt to check that the number of grid points divides evenly
! with the number of MPI tasks.
! rank 0 will display the bottom (southern) boundary wall
! rank (size-1) will display the top (northern) boundary wall
! if run with m=20 and 4 MPI tasks, we will have 5 grid lines per rank
! ParaView will display a 22x22 grid

!hn  call MPI_Bcast(m, 1, MPI_INTEGER, 0, MPI_COMM_WORLD, ierr)

! no check is done to make sure the two numbers below divide evenly
  mp = m/par_size                            ! columns for each proc

  print *, 'proc ', par_rank, ' out of ', par_size, ' m=', m, ' mp=', mp

  allocate ( Temp(0:m+1,0:mp+1), oldTemp(0:m+1,0:mp+1) )  ! mem for Temp
  allocate ( GradTemp(0:2,0:m+1,0:mp+1) )  ! mem for GradTemp

  call set_initial_bc()             ! set up boundary values


  do while (gdel > TOL)               ! iterate until error below threshold
    if(par_rank==0) write(*,*)'PJacobi : Iteration', iter, '/', MAXSTEPS
    if(iter > MAXSTEPS) then
      if(par_rank==0) write(*,*)'Iteration terminated (exceeds ', MAXSTEPS, ')'
      if(par_rank==0) write(*,*)'Normal end of execution'
      exit                            ! nonconvergent solution
    end if
#ifdef USE_CATALYST
    if(mod(iter,5)==0) call result_catalyst(Temp,m+1,mp+1,iter)
#endif

!call sleep(1)
    call simulate_one_timestep()

  end do

#ifdef USE_CATALYST
    call coprocessorfinalize()
#endif

  call result_vtr

  call MPIIOWriteData('Jacobi.bin')
  deallocate (Temp, oldTemp)

  call MPI_Finalize(ierr)

end program Jacobi
 
