// Catalyst API headers
#include "vtkCPDataDescription.h"
#include "vtkCPInputDataDescription.h"
#include "vtkCPProcessor.h"
#include "vtkCPPythonScriptPipeline.h"

// VTK API headers
#include "vtkSmartPointer.h"
#include "vtkDoubleArray.h"
#include "vtkPointData.h"
#include "vtkStructuredGrid.h"
#include "vtkStructuredGrid.h"

// Fortran specific header
#include "vtkCPPythonAdaptorAPI.h"


/** Create the grid
 */
extern "C" void creategriddata_(int* nx, int* ny, int*nz, double* x, double* y)
{
  double dx1,dy1,dz1;
  double * xp;
  if (!vtkCPPythonAdaptorAPI::GetCoProcessorData())
    {
    vtkGenericWarningMacro("Unable to access CoProcessorData.");
    return;
    }

  vtkSmartPointer<vtkStructuredGrid> grid = vtkSmartPointer<vtkStructuredGrid>::New();
  vtkSmartPointer<vtkPoints> points = vtkSmartPointer<vtkPoints>::New();
  for (int k=0; k<(*nz==0 ? 1 : *nz); k++)
  {
    for (int j=0; j<*ny; j++,y++)
    {
      xp = x;
      for (int i=0; i<*nx; i++,xp++)
      {
        points->InsertNextPoint(*xp,*y,0.0);
      }
    }
  }
  grid->SetDimensions(*nx,*ny,*nz);
  grid->SetPoints(points);
  vtkCPPythonAdaptorAPI::GetCoProcessorData()->GetInputDescriptionByName("input")->SetGrid(grid);
  vtkCPPythonAdaptorAPI::GetCoProcessorData()->GetInputDescriptionByName("input")->SetWholeExtent(0, *nx-1, 0, *ny-1, 0, *nz-1);
}

// Add a scalar field to the data container.
extern "C" void addscalarfield_(double* scalars, char* name)
{
  vtkCPInputDataDescription* idd =
    vtkCPPythonAdaptorAPI::GetCoProcessorData()->GetInputDescriptionByName("input");

  vtkStructuredGrid* grid = vtkStructuredGrid::SafeDownCast(idd->GetGrid());

  if (!grid)
    {
    vtkGenericWarningMacro("No adaptor grid to attach field data to.");
    return;
    }

  if (idd->IsFieldNeeded(name))
    {
    vtkSmartPointer<vtkDoubleArray> field = vtkSmartPointer<vtkDoubleArray>::New();
    field->SetNumberOfComponents(1);
    field->SetName(name);
    field->SetArray(scalars, grid->GetNumberOfPoints(), 1);
    grid->GetPointData()->AddArray(field);
    }
}


/** Add a vector field to the data
 */
extern "C" void addvectorfield_(double* uvw, char* name)
{
  vtkCPInputDataDescription* idd =
    vtkCPPythonAdaptorAPI::GetCoProcessorData()->GetInputDescriptionByName("input");
  vtkStructuredGrid* grid = vtkStructuredGrid::SafeDownCast(idd->GetGrid());

  if (!grid)
    {
    vtkGenericWarningMacro("No adaptor grid to attach field data to.");
    return;
    }

  if (idd->IsFieldNeeded(name))
    {
    vtkSmartPointer<vtkDoubleArray> field = vtkSmartPointer<vtkDoubleArray>::New();
    field->SetNumberOfComponents(3);
    field->SetName(name);
    field->SetArray(uvw, 3 * grid->GetNumberOfPoints(), 1);
    grid->GetPointData()->AddArray(field);
    }
}
