!> Coprocess result using CATALYST pipeline
!> Calls CXX callbacks
!> - creategriddata -> creategriddata_ in catalyst_callbacks.cxx
!> - addscalarfield -> addscalarfield_ in catalyst_callbacks.cxx
!> - addvectorfield -> addvectorfield_ in catalyst_callbacks.cxx
subroutine result_vtr

  use jacobi_module 
  implicit none
  
  
  real*8,  dimension(0:m+1) :: cx
  real*8,  dimension(0:mp+1) :: cy
  real(real8),  dimension(0:m+1,0:mp+1) :: my_rank_array
  integer minRealIndex(0:2), maxRealIndex(0:2)
  integer :: i,j
  integer :: flag
  integer :: nz=1
  real*8 :: t
  real*8 :: hsize
  character(len=8) :: rank
  
      t = 0.1*iter  

      hsize = 1.0/float(m+1)

      minRealIndex(0) = 0
      maxRealIndex(0) = m+1 ! no ghost in the X direction

      minRealIndex(1) = 0
      if( par_rank == par_size-1) then
        maxRealIndex(1) = mp+1
      else
        maxRealIndex(1) = mp
      endif

      minRealIndex(2) = 0
      maxRealIndex(2) = 0
      DO i = 0, m+1
         cx(i) = float(i) * hsize
      END DO
      DO i = 0, mp+1
         cy(i) = float(i + par_rank*mp) * hsize
      END DO
      my_rank_array(0:m+1,0:mp+1) = par_rank * 1.D0

    
  write(rank,'(i8.8)') par_rank 
  ! vtr file writing  
  open(1,file='last_step_'//rank//'.vtr',form = "formatted")
  
  write(1,'(A)') '<VTKFile type="RectilinearGrid" version="0.1" byte_order="LittleEndian">'
  write(1,*) '<RectilinearGrid WholeExtent="',minRealIndex(0),maxRealIndex(0),minRealIndex(1),maxRealIndex(1),1,1,'">'
  write(1,*) '<Piece Extent="',minRealIndex(0),maxRealIndex(0),minRealIndex(1),maxRealIndex(1),1,1,'">'
  write(1,'(A)') '<PointData>'
  write(1,'(A)') '<DataArray type="Float32" Name="Temp" NumberOfComponents="1" format="ascii">'
  write(1,*)     temp(minRealIndex(0):maxRealIndex(0),minRealIndex(1):maxRealIndex(1))
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '</PointData>'
  write(1,'(A)') '<CellData>'
  write(1,'(A)') '</CellData>'
  write(1,'(A)') '<Coordinates>'
  write(1,'(A)') '<DataArray type="Float32" Name="X_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     (cx(i),i=minRealIndex(0),maxRealIndex(0))
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '<DataArray type="Float32" Name="Y_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     (cy(i),i=minRealIndex(1),maxRealIndex(1))
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '<DataArray type="Float32" Name="Z_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     0.0
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '</Coordinates>'
  write(1,'(A)') '</Piece>'
  write(1,'(A)') '</RectilinearGrid>'
  write(1,'(A)') '</VTKFile> '

  close(1)

  ! pvd file writing  
  if (par_rank==0) then
    open(2,file='last_step.pvd',form = "formatted")
    write(2,'(A)') '<VTKFile type="Collection" version="0.1" yte_order="LittleEndian">'
    write(2,'(A)') '<Collection>'
    do i=1,par_size 
      write(rank,'(i8.8)') i-1 
      write(2,*) '<DataSet part="',rank,'" timestep="',t,'" file="last_step_',rank,'.vtr"/>'
    end do
    write(2,'(A)') '</Collection>'
    write(2,'(A)') '</VTKFile>'
    close(2)
  end if
  return

end subroutine
