!> Coprocess result using CATALYST pipeline
!> Calls CXX callbacks
!> - creategriddata -> creategriddata_ in catalyst_callbacks.cxx
!> - addscalarfield -> addscalarfield_ in catalyst_callbacks.cxx
!> - addvectorfield -> addvectorfield_ in catalyst_callbacks.cxx
subroutine result_catalyst()
  use jacobi_module
  use iso_c_binding
  implicit none
  
  real*8,  dimension(0:m+1) :: x
  real*8,  dimension(0:mp+1) :: y  
  real(real8),  dimension(0:m+1,0:mp+1) :: my_rank_array
  integer :: i,j
  integer :: flag
  integer :: nz=1
  real*8 :: t
  real*8 :: hsize
  
  t = 0.1*iter  ! time step ~ 0.1s
  if (par_rank == 0) write(*,*) "CATALYST coprocessing at t=", t
  hsize = 1.0/float(m+1)   ! delta x = delta y

  do i=0,m+1
    x(i) = float(i) * hsize
  end do
  do i=0,mp+1
    y(i) = float(i+par_rank*mp) * hsize
  end do
  my_rank_array(0:m+1,0:mp+1) = par_rank * 1.D0
  
!     if( par_rank == 0) print *, 'id ', par_rank, ' m =', m, ' mp=', mp
! all ranks send their block including their south boundary wall
! the northern-most rank sends also the northern boundary wall
 
  !----------------------------------------------------------------------------
  ! Request for coprocessing flag (flag=1 = coprocessing to be made)
  !----------------------------------------------------------------------------
  call requestdatadescription(iter,t,flag)
  
  if (flag .ne. 0) then
  
    !--------------------------------------------------------------------------
    ! Check if the grid has already been built (flag=1 : grid not built yet)
    !--------------------------------------------------------------------------
    call needtocreategrid(flag)
    if (flag .ne. 0) then
      !------------------------------------------------------------------------
      ! Call grid creation callback (creategriddata_ in catalyst_callbacks.cxx)
      !------------------------------------------------------------------------
      call creategriddata(m+2,mp+2,nz,x(0),y(0)) ! see catalyst_callbacks.cxx::creategriddata_ 
    end if
    
    !--------------------------------------------------------------------------
    ! Add temperature field
    !--------------------------------------------------------------------------
    call addscalarfield(Temp,"Temp"//char(0))
      
    !--------------------------------------------------------------------------
    ! Add here the scalar field "my_rank_array" 
    !--------------------------------------------------------------------------
    !...
    
    !--------------------------------------------------------------------------
    ! Add here the vectort field "GradTemp" 
    !--------------------------------------------------------------------------
    !...
    
    !--------------------------------------------------------------------------
    ! Do coprocessing
    !--------------------------------------------------------------------------
    call coprocess()

  end if

  return

end subroutine
