
from paraview.simple import *
from paraview import coprocessing


#--------------------------------------------------------------
# Code generated from cpstate.py to create the CoProcessor.
# ParaView 5.4.1 64 bits

#--------------------------------------------------------------
# Global screenshot output options
imageFileNamePadding=0
rescale_lookuptable=False


# ----------------------- CoProcessor definition -----------------------

def CreateCoProcessor():
  def _CreatePipeline(coprocessor, datadescription):
    class Pipeline:
      # state file generated using paraview version 5.4.1

      # ----------------------------------------------------------------
      # setup views used in the visualization
      # ----------------------------------------------------------------

      #### disable automatic camera reset on 'Show'
      paraview.simple._DisableFirstRenderCameraReset()

      # Create a new 'Render View'
      renderView1 = CreateView('RenderView')
      renderView1.ViewSize = [1050, 621]
      renderView1.InteractionMode = '2D'
      renderView1.AxesGrid = 'GridAxes3DActor'
      renderView1.CenterOfRotation = [0.5, 0.5, 0.0]
      renderView1.StereoType = 0
#      renderView1.CameraPosition = [0.5, 0.5, 10000.0]
      renderView1.CameraPosition = [0.5, 0.5, 2.7320508075688776]
      renderView1.CameraFocalPoint = [0.5, 0.5, 0.0]
      renderView1.CameraParallelScale = 0.7071067811865476
      renderView1.Background = [0.32, 0.34, 0.43]

      # register the view with coprocessor
      # and provide it with information such as the filename to use,
      # how frequently to write the images, etc.
      coprocessor.RegisterView(renderView1,
          filename='image_%t.png', freq=10, fittoscreen=0, magnification=1, width=1050, height=621, cinema={})
      renderView1.ViewTime = datadescription.GetTime()

      # ----------------------------------------------------------------
      # setup the data processing pipelines
      # ----------------------------------------------------------------

      # create a new 'PVD Reader'
      # create a producer from a simulation input
      last_steppvd = coprocessor.CreateProducer(datadescription, 'input')

      # ----------------------------------------------------------------
      # setup color maps and opacity mapes used in the visualization
      # note: the Get..() functions create a new object, if needed
      # ----------------------------------------------------------------

      # get color transfer function/color map for 'Rank'
      rankLUT = GetColorTransferFunction('Rank')
      rankLUT.RGBPoints = [0.0, 0.231373, 0.298039, 0.752941, 1.5, 0.865003, 0.865003, 0.865003, 3.0, 0.705882, 0.0156863, 0.14902]
      rankLUT.ScalarRangeInitialized = 1.0

      # get opacity transfer function/opacity map for 'Rank'
      rankPWF = GetOpacityTransferFunction('Rank')
      rankPWF.Points = [0.0, 0.0, 0.5, 0.0, 3.0, 1.0, 0.5, 0.0]
      rankPWF.ScalarRangeInitialized = 1

      # ----------------------------------------------------------------
      # setup the visualization in view 'renderView1'
      # ----------------------------------------------------------------

      # show data from last_steppvd
      last_steppvdDisplay = Show(last_steppvd, renderView1)
      # trace defaults for the display properties.
      last_steppvdDisplay.Representation = 'Surface With Edges'
      last_steppvdDisplay.ColorArrayName = ['POINTS', 'Rank']
      last_steppvdDisplay.LookupTable = rankLUT
      last_steppvdDisplay.OSPRayScaleArray = 'Rank'
      last_steppvdDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
      last_steppvdDisplay.SelectOrientationVectors = 'None'
      last_steppvdDisplay.ScaleFactor = 0.0
      last_steppvdDisplay.SelectScaleArray = 'None'
      last_steppvdDisplay.GlyphType = 'Arrow'
      last_steppvdDisplay.GlyphTableIndexArray = 'None'
      last_steppvdDisplay.DataAxesGrid = 'GridAxesRepresentation'
      last_steppvdDisplay.PolarAxes = 'PolarAxesRepresentation'
#      last_steppvdDisplay.SetScaleArray = ['POINTS', 'Rank']
#      last_steppvdDisplay.ScaleTransferFunction = 'PiecewiseFunction'
#      last_steppvdDisplay.OpacityArray = ['POINTS', 'Rank']
#      last_steppvdDisplay.OpacityTransferFunction = 'PiecewiseFunction'

      # show color legend
      last_steppvdDisplay.SetScalarBarVisibility(renderView1, True)

      # setup the color legend parameters for each legend in this view

      # get color legend/bar for rankLUT in view renderView1
      rankLUTColorBar = GetScalarBar(rankLUT, renderView1)
      rankLUTColorBar.Title = 'Rank'
      rankLUTColorBar.ComponentTitle = ''

      # ----------------------------------------------------------------
      # finally, restore active source
      SetActiveSource(last_steppvd)
      # ----------------------------------------------------------------
    return Pipeline()

  class CoProcessor(coprocessing.CoProcessor):
    def CreatePipeline(self, datadescription):
      self.Pipeline = _CreatePipeline(self, datadescription)

  coprocessor = CoProcessor()
  # these are the frequencies at which the coprocessor updates.
  freqs = {'input': [10]}
  coprocessor.SetUpdateFrequencies(freqs)
  return coprocessor


#--------------------------------------------------------------
# Global variable that will hold the pipeline for each timestep
# Creating the CoProcessor object, doesn't actually create the ParaView pipeline.
# It will be automatically setup when coprocessor.UpdateProducers() is called the
# first time.
coprocessor = CreateCoProcessor()

#--------------------------------------------------------------
# Enable Live-Visualizaton with ParaView and the update frequency
coprocessor.EnableLiveVisualization(False, 1)

# ---------------------- Data Selection method ----------------------

def RequestDataDescription(datadescription):
    "Callback to populate the request for current timestep"
    global coprocessor
    if datadescription.GetForceOutput() == True:
        # We are just going to request all fields and meshes from the simulation
        # code/adaptor.
        for i in range(datadescription.GetNumberOfInputDescriptions()):
            datadescription.GetInputDescription(i).AllFieldsOn()
            datadescription.GetInputDescription(i).GenerateMeshOn()
        return

    # setup requests for all inputs based on the requirements of the
    # pipeline.
    coprocessor.LoadRequestedData(datadescription)

# ------------------------ Processing method ------------------------

def DoCoProcessing(datadescription):
    "Callback to do co-processing for current timestep"
    global coprocessor

    # Update the coprocessor by providing it the newly generated simulation data.
    # If the pipeline hasn't been setup yet, this will setup the pipeline.
    coprocessor.UpdateProducers(datadescription)

    # Write output data, if appropriate.
    coprocessor.WriteData(datadescription);

    # Write image capture (Last arg: rescale lookup table), if appropriate.
    coprocessor.WriteImages(datadescription, rescale_lookuptable=rescale_lookuptable,
        image_quality=0, padding_amount=imageFileNamePadding)

    # Live Visualization, if enabled.
    coprocessor.DoLiveVisualization(datadescription, "localhost", 22222)
