

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "result_vtr.h"

char* build_file_name(char* dest, int r) {
   if (dest==NULL) {
      dest = (char*) calloc(30,sizeof(char));
   }
   strcpy(dest,"last_step_00000000.vtr");
   dest[17] += r; // Only for r<10 !
   return dest;
}
   

void  result_vtr(double* Temp, double* GradTemp, int par_rank, int m, int mp, int iter, int par_size) {


 //  use jacobi_module 
 //  implicit none
  
  /*
  real*8,  dimension(0:m+1) :: cx
  real*8,  dimension(0:mp+1) :: cy
  integer minRealIndex(0:2), maxRealIndex(0:2)
  integer :: i,j
  integer :: flag
  integer :: nz=1
  real*8 :: t
  real*8 :: hsize
  character(len=8) :: rank
  */

  double* cx = (double*) malloc(sizeof(double)*(m+2));
  double* cy = (double*) malloc(sizeof(double)*(mp+2));
  double* my_rank_array = (double*) malloc(sizeof(double)*(m+2)*(mp+2));
  int minRealIndex[3], maxRealIndex[3];
  int i,j,k;
  int flag;
  int nz=1;
  double t;
  double hsize; 
  char* file_name=NULL;
  
  t = 0.1*iter;

  hsize = 1.0/(m+1);

  minRealIndex[0] = 0;
  maxRealIndex[0] = m+1; //! no ghost in the X direction

  minRealIndex[1] = 0;
  if( par_rank == par_size-1) {
     maxRealIndex[1] = mp+1;
  } else {
     maxRealIndex[1] = mp;
  }

  minRealIndex[2] = 0;
  maxRealIndex[2] = 0;
  /*
  DO i = 0, m+1
     cx(i) = float(i) * hsize
  END DO
  DO i = 0, mp+1
     cy(i) = float(i + par_rank*mp) * hsize
  END DO
  */

  for (i=0; i<=m+1; ++i) {
     cx[i] = i * hsize;
  }
  for (i=0; i<=mp+1; ++i) {
     cy[i] = (i + par_rank*mp) * hsize;
  }
  for (i=0; i<=m+1; ++i) {
     for (j=0; j<=mp+1; ++j) {
        my_rank_array[i+(m+2)*j] = par_rank;
     }
  }

  //write(rank,'(i8.8)') par_rank 
  printf("par_rank =%i\n",par_rank);

  //! vtr file writing  
  file_name = build_file_name(file_name,par_rank);
  printf("vtr file = %s\n",file_name);

  
  FILE * OUT = fopen(file_name,"w");
  fprintf(OUT,"<VTKFile type=\"RectilinearGrid\" version=\"0.1\" byte_order=\"LittleEndian\">\n");
  fprintf(OUT,"<RectilinearGrid WholeExtent=\"%12i %12i %12i %12i %12i %12i\" >\n",minRealIndex[0],maxRealIndex[0],minRealIndex[1],maxRealIndex[1],1,1);
  fprintf(OUT,"<Piece Extent=\"%12i %12i %12i %12i %12i %12i\" >\n",minRealIndex[0],maxRealIndex[0],minRealIndex[1],maxRealIndex[1],1,1);
  fprintf(OUT,"<PointData>\n");
  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"Temp\" NumberOfComponents=\"1\" format=\"ascii\">\n");


  for(j=minRealIndex[1];j<=maxRealIndex[1];++j) {
      for (i=minRealIndex[0];i<=maxRealIndex[0]; ++i) {
         fprintf(OUT,"%12.11E ",Temp[i+(m+2)*j]);
      }
  }

  fprintf(OUT,"\n");
  fprintf(OUT,"</DataArray>\n");

  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"Rank\" NumberOfComponents=\"1\" format=\"ascii\">\n");
  for(j=minRealIndex[1];j<=maxRealIndex[1];++j) {
     for (i=minRealIndex[0];i<=maxRealIndex[0]; ++i) {
        fprintf(OUT,"%12.11E ",my_rank_array[i+(m+2)*j]);
      }
  }
  fprintf(OUT,"\n");
  fprintf(OUT,"</DataArray>\n");

  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"GradTemp\" NumberOfComponents=\"3\" format=\"ascii\">\n");
  for(j=minRealIndex[1];j<=maxRealIndex[1];++j) {
     for (i=minRealIndex[0];i<=maxRealIndex[0]; ++i) {
        for(k=0;k<=2;++k) {
           fprintf(OUT,"%12.11E ",GradTemp[j*3*(m+2) + (3*i + k)]);
        }
     }
  }

  fprintf(OUT,"\n");
  fprintf(OUT,"</DataArray>\n");

  fprintf(OUT,"</PointData>\n");
  fprintf(OUT,"<CellData>\n");
  fprintf(OUT,"</CellData>\n");
  fprintf(OUT,"<Coordinates>\n");
  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"X_COORDINATES\" NumberOfComponents=\"1\" format=\"ascii\">\n");
  for (i=minRealIndex[0];i<=maxRealIndex[0];++i) {
      fprintf(OUT,"%12.11E ",cx[i]);
  }
  fprintf(OUT,"\n");
  fprintf(OUT,"</DataArray>\n");
  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"Y_COORDINATES\" NumberOfComponents=\"1\" format=\"ascii\">\n");
  for (i=minRealIndex[1];i<=maxRealIndex[1];++i) {
      fprintf(OUT,"%12.11E ",cy[i]);
  }
  fprintf(OUT,"\n");
  fprintf(OUT,"</DataArray>\n");
  fprintf(OUT,"<DataArray type=\"Float32\" Name=\"Z_COORDINATES\" NumberOfComponents=\"1\" format=\"ascii\">\n");
  fprintf(OUT,"0.0000\n");
  fprintf(OUT,"</DataArray>\n");
  fprintf(OUT,"</Coordinates>\n");
  fprintf(OUT,"</Piece>\n");
  fprintf(OUT,"</RectilinearGrid>\n");
  fprintf(OUT,"</VTKFile>\n");

  fclose(OUT);

  // write(1,'(A)') '<VTKFile type="RectilinearGrid" version="0.1" byte_order="LittleEndian">'
  // write(1,*) '<RectilinearGrid WholeExtent="',minRealIndex(0),maxRealIndex(0),minRealIndex(1),maxRealIndex(1),1,1,'">'
  // write(1,*) '<Piece Extent="',minRealIndex(0),maxRealIndex(0),minRealIndex(1),maxRealIndex(1),1,1,'">'
  //  write(1,'(A)') '<PointData>'
  // write(1,'(A)') '<DataArray type="Float32" Name="Temp" NumberOfComponents="1" format="ascii">'
  // write(1,*)     temp(minRealIndex(0):maxRealIndex(0),minRealIndex(1):maxRealIndex(1))
  // write(1,'(A)') '</DataArray>'
  // write(1,'(A)') '</PointData>'
  // write(1,'(A)') '<CellData>'
  // write(1,'(A)') '</CellData>'
  // write(1,'(A)') '<Coordinates>'
  // write(1,'(A)') '<DataArray type="Float32" Name="X_COORDINATES" NumberOfComponents="1" format="ascii">'
  // write(1,*)     (cx(i),i=minRealIndex(0),maxRealIndex(0))
  // write(1,'(A)') '</DataArray>'
  // write(1,'(A)') '<DataArray type="Float32" Name="Y_COORDINATES" NumberOfComponents="1" format="ascii">'
  // write(1,*)     (cy(i),i=minRealIndex(1),maxRealIndex(1))
  // write(1,'(A)') '</DataArray>'
  // write(1,'(A)') '<DataArray type="Float32" Name="Z_COORDINATES" NumberOfComponents="1" format="ascii">'
  // write(1,*)     0.0
  // write(1,'(A)') '</DataArray>'
  // write(1,'(A)') '</Coordinates>'
  // write(1,'(A)') '</Piece>'
  // write(1,'(A)') '</RectilinearGrid>'
  // write(1,'(A)') '</VTKFile> '

  // close(1)

  // ! pvd file writing  
 
  if (par_rank==0) {
     OUT = fopen("last_step.pvd","w");
     fprintf(OUT, "<VTKFile type=\"Collection\" version=\"0.1\" yte_order=\"LittleEndian\">\n");
     fprintf(OUT,"<Collection>\n");
     for (i=0; i<par_size; ++i) {
         char rank='0' + i;
         fprintf(OUT," <DataSet part=\"%08i\" timestep=\"%8.5f\" file=\"%s\" />\n",i,t,build_file_name(file_name,i));
     }
     fprintf(OUT,"</Collection>\n");
     fprintf(OUT,"</VTKFile>\n");
     fclose(OUT);
  }
  free(file_name);
 
 // if (par_rank==0) then
 //   open(2,file='last_step.pvd',form = "formatted")
 //   write(2,'(A)') '<VTKFile type="Collection" version="0.1" yte_order="LittleEndian">'
 //   write(2,'(A)') '<Collection>'
 //   do i=1,par_size 
 //     write(rank,'(i8.8)') i-1 
 //     write(2,*) '<DataSet part="',rank,'" timestep="',t,'" file="last_step_',rank,'.vtr"/>'
 //   end do
 //   write(2,'(A)') '</Collection>'
 //   write(2,'(A)') '</VTKFile>'
 //   close(2)
 // end if
}

