
from paraview.simple import *
from paraview import coprocessing


#--------------------------------------------------------------
# Code generated from cpstate.py to create the CoProcessor.
# ParaView 5.4.1 64 bits

#--------------------------------------------------------------
# Global screenshot output options
imageFileNamePadding=0
rescale_lookuptable=False


# ----------------------- CoProcessor definition -----------------------

def CreateCoProcessor():
  def _CreatePipeline(coprocessor, datadescription):
    class Pipeline:
      # state file generated using paraview version 5.4.1

      # ----------------------------------------------------------------
      # setup views used in the visualization
      # ----------------------------------------------------------------

      #### disable automatic camera reset on 'Show'
      paraview.simple._DisableFirstRenderCameraReset()

      # Create a new 'Render View'
      renderView1 = CreateView('RenderView')
      renderView1.ViewSize = [844, 497]
      renderView1.AxesGrid = 'GridAxes3DActor'
      renderView1.CenterOfRotation = [0.4761904776096344, 0.4761904776096344, 0.0]
      renderView1.StereoType = 0
      renderView1.CameraPosition = [0.4761904776096344, 0.4761904776096344, 2.6019531578200223]
      renderView1.CameraFocalPoint = [0.4761904776096344, 0.4761904776096344, 0.0]
      renderView1.CameraParallelScale = 0.6734350317084666
      renderView1.Background = [0.32, 0.34, 0.43]

      # register the view with coprocessor
      # and provide it with information such as the filename to use,
      # how frequently to write the images, etc.
      coprocessor.RegisterView(renderView1,
          filename='image_%t.png', freq=10, fittoscreen=0, magnification=1, width=844, height=497, cinema={})
      renderView1.ViewTime = datadescription.GetTime()

      # ----------------------------------------------------------------
      # setup the data processing pipelines
      # ----------------------------------------------------------------

      # create a new 'PVTrivialProducer'
      # create a producer from a simulation input
      extractinput = coprocessor.CreateProducer(datadescription, 'input')

      # create a new 'Annotate Time Filter'
      annotateTimeFilter1 = AnnotateTimeFilter(Input=extractinput)

      # ----------------------------------------------------------------
      # setup color maps and opacity mapes used in the visualization
      # note: the Get..() functions create a new object, if needed
      # ----------------------------------------------------------------

      # get color transfer function/color map for 'Temp'
      tempLUT = GetColorTransferFunction('Temp')
      tempLUT.RGBPoints = [-8.742277657347586e-08, 0.231373, 0.298039, 0.752941, 0.49860186974076015, 0.865003, 0.865003, 0.865003, 0.9972038269042969, 0.705882, 0.0156863, 0.14902]
      tempLUT.ScalarRangeInitialized = 1.0

      # get opacity transfer function/opacity map for 'Temp'
      tempPWF = GetOpacityTransferFunction('Temp')
      tempPWF.Points = [-8.742277657347586e-08, 0.0, 0.5, 0.0, 0.9972038269042969, 1.0, 0.5, 0.0]
      tempPWF.ScalarRangeInitialized = 1

      # ----------------------------------------------------------------
      # setup the visualization in view 'renderView1'
      # ----------------------------------------------------------------

      # show data from extractinput
      extractinputDisplay = Show(extractinput, renderView1)
      # trace defaults for the display properties.
      extractinputDisplay.Representation = 'Surface With Edges'
      extractinputDisplay.ColorArrayName = ['POINTS', 'Temp']
      extractinputDisplay.LookupTable = tempLUT
      extractinputDisplay.OSPRayScaleArray = 'Temp'
      extractinputDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
      extractinputDisplay.SelectOrientationVectors = 'None'
      extractinputDisplay.ScaleFactor = 0.09523809552192689
      extractinputDisplay.SelectScaleArray = 'None'
      extractinputDisplay.GlyphType = 'Arrow'
      extractinputDisplay.GlyphTableIndexArray = 'None'
      extractinputDisplay.DataAxesGrid = 'GridAxesRepresentation'
      extractinputDisplay.PolarAxes = 'PolarAxesRepresentation'
      extractinputDisplay.ScalarOpacityFunction = tempPWF
      extractinputDisplay.ScalarOpacityUnitDistance = 0.18279839137016116

      # show color legend
      extractinputDisplay.SetScalarBarVisibility(renderView1, True)

      # show data from annotateTimeFilter1
      annotateTimeFilter1Display = Show(annotateTimeFilter1, renderView1)

      # setup the color legend parameters for each legend in this view

      # get color legend/bar for tempLUT in view renderView1
      tempLUTColorBar = GetScalarBar(tempLUT, renderView1)
      tempLUTColorBar.Title = 'Temp'
      tempLUTColorBar.ComponentTitle = ''

      # ----------------------------------------------------------------
      # finally, restore active source
      SetActiveSource(annotateTimeFilter1)
      # ----------------------------------------------------------------
    return Pipeline()

  class CoProcessor(coprocessing.CoProcessor):
    def CreatePipeline(self, datadescription):
      self.Pipeline = _CreatePipeline(self, datadescription)

  coprocessor = CoProcessor()
  # these are the frequencies at which the coprocessor updates.
  freqs = {'input': [10, 10]}
  coprocessor.SetUpdateFrequencies(freqs)
  return coprocessor


#--------------------------------------------------------------
# Global variable that will hold the pipeline for each timestep
# Creating the CoProcessor object, doesn't actually create the ParaView pipeline.
# It will be automatically setup when coprocessor.UpdateProducers() is called the
# first time.
coprocessor = CreateCoProcessor()

#--------------------------------------------------------------
# Enable Live-Visualizaton with ParaView and the update frequency
coprocessor.EnableLiveVisualization(False, 1)

# ---------------------- Data Selection method ----------------------

def RequestDataDescription(datadescription):
    "Callback to populate the request for current timestep"
    global coprocessor
    if datadescription.GetForceOutput() == True:
        # We are just going to request all fields and meshes from the simulation
        # code/adaptor.
        for i in range(datadescription.GetNumberOfInputDescriptions()):
            datadescription.GetInputDescription(i).AllFieldsOn()
            datadescription.GetInputDescription(i).GenerateMeshOn()
        return

    # setup requests for all inputs based on the requirements of the
    # pipeline.
    coprocessor.LoadRequestedData(datadescription)

# ------------------------ Processing method ------------------------

def DoCoProcessing(datadescription):
    "Callback to do co-processing for current timestep"
    global coprocessor

    # Update the coprocessor by providing it the newly generated simulation data.
    # If the pipeline hasn't been setup yet, this will setup the pipeline.
    coprocessor.UpdateProducers(datadescription)

    # Write output data, if appropriate.
    coprocessor.WriteData(datadescription);

    # Write image capture (Last arg: rescale lookup table), if appropriate.
    coprocessor.WriteImages(datadescription, rescale_lookuptable=rescale_lookuptable,
        image_quality=0, padding_amount=imageFileNamePadding)

    # Live Visualization, if enabled.
    coprocessor.DoLiveVisualization(datadescription, "localhost", 22222)
