SUBROUTINE calcul_advection_diffusion
USE m_type
IMPLICIT NONE


REAL,DIMENSION(nx-1,ny-1) :: fag,fad,fdg,fdd,fdh,fdb
INTEGER :: i,j

!On fait tous les calculs de flux et de la température pour le cas de la l'advection-diffusion
!Tous les flux vont influencer la température


DO i=2,nx-2

	DO j=2,ny-2

		fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
		fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
		
		fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
		fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
		fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
		fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)
	

	END DO
		
END DO



!bord AD
i=1
DO j=2,ny-2

	fag(i,j)=T0*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
	
	fdg(i,j)=-2*alpha*(T(i,j)-T0)*m%dyn(j)/m%dxc(i)
	fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)

END DO



!bord CD
j=ny-1
DO i=2,nx-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
	
	fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
	fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)

END DO



!bord AB
j=1

DO i=2,nx-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
	
	fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
	fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
	fdb(i,j)=0
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)

END DO



!bord BC
i=nx-1
DO j=2,ny-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)
	
	fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
	fdd(i,j)=-fdg(i,j)
	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)

END DO



!point A
i=1
j=1

	fag(i,j)=T0*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
	
	fdg(i,j)=-2*alpha*(T(i,j)-T0)*m%dyn(j)/m%dxc(i)
	fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
	fdb(i,j)=0
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)



!point B
i=nx-1
j=1

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)
	
	fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
	fdd(i,j)=-fdg(i,j)
	fdb(i,j)=0
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)




!point C
i=nx-1
j=ny-1


	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)
	
	fdg(i,j)=-alpha*(T(i,j)-T(i-1,j))*m%dyn(j)/m%dxc(i-1)
	fdd(i,j)=-fdg(i,j)
	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)

		
		


!point D
i=1
j=ny-1


	fag(i,j)=T0*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)
	
	fdg(i,j)=-2*alpha*(T(i,j)-T0)*m%dyn(j)/m%dxc(i)
	fdd(i,j)=alpha*(T(i+1,j)-T(i,j))*m%dyn(j)/m%dxc(i)
	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)
	
	
	
		
!calcul de la température

DO i=1,nx-1

	DO j=1,ny-1

		T(i,j)=T(i,j)+(dt/(m%dxn(i)*m%dyn(j)))*(fag(i,j)-fad(i,j)+fdd(i,j)+fdb(i,j)+fdh(i,j)+fdg(i,j))

	END DO
	
END DO



END SUBROUTINE calcul_advection_diffusion
