subroutine mainloop
USE m_type
implicit none

Integer::nf,err
Real::ta,td
character (len=80) :: filename
integer :: vars,options

! Pour prendre en compte les arguments derriere l'executable fortran
! notamment la commande : -trace trace.txt qui est utile pour comprendre
! un probleme de connection avec VisIt
#ifdef USE_VISIT
include "visitfortransimV2interface.inc"
  external processvisitcommand
  integer processvisitcommand

  call simulationarguments()
      err = visitsetupenv()
      err = visitinitializesim("prog", 4, &
     "Interface to prog", 17, &
     "/no/useful/path", 15, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN)
  
      visRunFlag = .FALSE.
#endif    

!calcul du nombre d'iterations a effectuer en fonction du type de transfert  
if (typetransfert=='advection') THEN

  tfin=(Larg/(2*U0))

else if (typetransfert=='diffusion') THEN

  tfin=Haut**2/(4*alpha)
  tfin=0.002

else if (typetransfert=='advection-diffusion') THEN

  td=Haut**2/alpha
  ta=(Larg/(U0))
  tfin=max(ta,td)
endif

nf=floor(tfin/dt)
MAXSTEPS=nf
write(*,*) "Nombre d'iterations necessaires pour le calcul en cours = ", nf
iter=0

#ifdef USE_VISIT
      err = visitinitializeruntime()
      err = visittimestepchanged()
      err = visitaddplot("Mesh", 4, "mesh", 4)
      err = visitaddplot("Pseudocolor", 11, "temperat", 8)
      err = visitdrawplots()
#endif

do while (iter<nf)


if(iter > MAXSTEPS) then
    write(*,*)'Iteration terminated (exceeds ', MAXSTEPS, ')'
    exit                            ! nonconvergent solution
  end if


#ifdef USE_VISIT
    ! sortie image jpg tous les 10 pas de temps au debut du calcul
    if ((iter <= 100) .and. mod(iter,10)==0) then
      err = visittimestepchanged()
      err = visitupdateplots()
      write (filename, "(A12,I4.4,A4)"),"advdiff_img_",iter,".jpg"
      err=visitsavewindow(filename,20,800,800,VISIT_IMAGEFORMAT_JPEG)
     if(err.eq.VISIT_OKAY) then
        write (6,*) 'Saved ', filename
      endif
    end if

    ! sortie fichier VTK tous les 10 pas de temps au debut du calcul
    if ((iter <= 100) .and. mod(iter,10)==0) then
      err = visittimestepchanged()
      err = visitnamelistalloc(vars)
      err = visitnamelistaddname(vars, "default", 7)
      err = visitnamelistaddname(vars, "mesh2d/nodeid", 13)

      err = visitoptionlistalloc(options)
      err = visitoptionlistsetvalueb(options,"Strip mesh name prefix", 22, 1);

      write (filename, "(A8,I4.4)"), "advdiff_",iter
      err=visitexportdatabasewithoptions(filename,12,"VTK_1.0",7,vars,options)
      if(err.eq.VISIT_OKAY) then
        write (6,*) 'Exported ',trim(filename),'.vtk'
      else
        write (6,*) 'Pb visitexportdatabasewithoptions'
      endif
      err = visitnamelistfree(vars)
      err = visitoptionlistfree(options)
    end if
    
#endif

call simulate_one_timestep()
  
 end do

#ifdef USE_VISIT
 err = VisItDisconnect() 
#endif
 
end subroutine 
