SUBROUTINE creer_maillage
USE m_type
IMPLICIT NONE

INTEGER :: i,j

!!maillage en x (il est toujours uniforme)

!ecart entre les noeuds

DO i=1,nx1
	m%dxn(i) = Larg/nx1
END DO

!position des noeuds

DO i=1,nx
	pnx(i) = Larg*(i-1)/nx1
END DO

!ecart entre les centres

DO i=1,nx-2
	m%dxc(i) = (m%dxn(i+1)+m%dxn(i))/2
END DO



!position des centres

m%xc(1)=m%dxn(1)/2

DO i=2,nx-1
	m%xc(i)=m%xc(i-1)+m%dxc(i-1)
END DO



!position des noeuds --> tableaux a 2 dimensions

DO j=1, ny
	DO i=1,nx-1

		m%xn(i,j)=m%xc(i)-m%dxn(i)/2
	END DO
	m%xn(nx,j)=m%xc(nx1)+m%dxn(nx1)/2
	
END DO




if (typemaillage=='uniforme') then


	!!maillage uniforme en y: 

	!ecart entre les noeuds

	DO j=1,ny-1
		m%dyn(j) = Haut/(ny-1)
		
	END DO
!position des noeuds

	DO i=1,ny
		pny(i) = Haut*(i-1)/(ny-1)
	END DO


	!ecart entre les centres

	DO j=1,ny-2
		m%dyc(j) = (m%dyn(j+1)+m%dyn(j))/2
	END DO


	!position des centres

	m%yc(1)=m%dyn(1)/2

	DO j=2,ny-1
		m%yc(j)=m%yc(j-1)+m%dyc(j-1)
	END DO


	!position des noeuds --> tableaux a 2 dimensions

	DO i=1,nx
		DO j=1,ny1
			m%yn(i,j)=m%yc(j)-m%dyn(j)/2
		END DO
		m%yn(i,ny)=m%yc(ny1)+m%dyn(ny1)/2
	END DO



else if (typemaillage=='nonuniforme') then

	!!maillage non uniforme en y : rafine en bas



	!position des noeuds

	DO i=1,nx
		DO j=1,ny
			m%yn(i,j)=Haut*(tanh(beta*dble(j)/dble(ny-1))/tanh(beta))
			pny(j)= Haut*(tanh(beta*dble(j)/dble(ny-1))/tanh(beta))
		END DO
	END DO


	!ecart entre les noeuds

	DO j=1,ny-1
		m%dyn(j)=m%yn(1,j+1)-m%yn(1,j)
	END DO

	!ecart entre les centres

	DO j=1,ny-2
		m%dyc(j) = (m%dyn(j+1)+m%dyn(j))/2
	END DO


	!position des centres

	m%yc(1)=m%dyn(1)/2

	DO j=2,ny-1
		m%yc(j)=m%yc(j-1)+m%dyc(j-1)
	END DO


end if

END SUBROUTINE creer_maillage
