SUBROUTINE calcul_diffusion
USE m_type
IMPLICIT NONE

REAL,DIMENSION(nx-1,ny-1) :: fag,fad,fdg,fdd,fdh,fdb
INTEGER :: i,j


!On fait tous les calculs de flux et de la température pour le cas de la diffusion pure
!Il y a certaines conditions limites qui ont changé (bords AD, BC et AB), il faut donc les prendre en compte
!Seuls les flux diffusifs haut et bas vont influencer la température


!Calcul des flux à l'intérieur du domaine

DO i=2,nx-2

	DO j=2,ny-2
		
		fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
		fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)
	
	END DO
		
END DO



!bord AD
i=1
DO j=2,ny-2

	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)

END DO


!bord CD
j=ny-1
DO i=2,nx-2

	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)

END DO



!bord AB
j=1

DO i=2,nx-2

	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)
	fdb(i,j)=-fdh(i,j)

END DO



!bord BC
i=nx-1
DO j=2,ny-2

	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)

END DO




!point A
i=1
j=1

	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)
	fdb(i,j)=-fdh(i,j)



!point B
i=nx-1
j=1

	fdh(i,j)=alpha*(T(i,j+1)-T(i,j))*m%dxn(i)/m%dyc(j)
	fdb(i,j)=-fdh(i,j)



!point C
i=nx-1
j=ny-1

	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)
		
		


!point D
i=1
j=ny-1

	fdb(i,j)=-alpha*(T(i,j)-T(i,j-1))*m%dxn(i)/m%dyc(j-1)
	fdh(i,j)=2*alpha*(T1-T(i,j))*m%dxn(i)/m%dyc(j-1)
	
	
	
		
!calcul de la température

DO i=1,nx-1

	DO j=1,ny-1

		T(i,j)=T(i,j)+(dt/(m%dxn(i)*m%dyn(j)))*(fdb(i,j)+fdh(i,j))
	END DO
	
END DO



END SUBROUTINE calcul_diffusion
