subroutine mainloop
USE m_type
implicit none

Integer::nf,err
Real::ta,td

! Pour prendre en compte les arguments derriere l'executable fortran
! notamment la commande : -trace trace.txt qui est utile pour comprendre
! un probleme de connection avec VisIt
#ifdef USE_VISIT
include "visitfortransimV2interface.inc"
  external processvisitcommand
  integer processvisitcommand

  call simulationarguments()
      err = visitsetupenv()
      err = visitinitializesim("prog", 4, &
     "Interface to prog", 17, &
     "/no/useful/path", 15, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN, &
     VISIT_F77NULLSTRING, VISIT_F77NULLSTRINGLEN)
  
  visRunFlag = .FALSE.
  write(*,*) 'lancer ViSit et ouvrir le dernier fichier $HOME/.visit/simulations/*.sim2'
#endif    

!calcul du nombre d'iterations a effectuer en fonction du type de transfert  
if (typetransfert=='advection') THEN

  tfin=(Larg/(2*U0))

else if (typetransfert=='diffusion') THEN

  tfin=Haut**2/(4*alpha)
  tfin=0.002

else if (typetransfert=='advection-diffusion') THEN

  td=Haut**2/alpha
  ta=(Larg/(U0))
  tfin=max(ta,td)
endif

nf=floor(tfin/dt)
MAXSTEPS=nf
write(*,*) "Nombre d'iterations necessaires pour ce cas de calcul = ", nf
iter=0

!Boucle servant a connecter visit et a lui dire d'attendre
write(*,*) "Debut du calcul"
do while (iter<nf)


  if(iter > MAXSTEPS) then
    write(*,*)'Iteration terminated (exceeds ', MAXSTEPS, ')'
    exit                            ! nonconvergent solution
  end if


#ifdef USE_VISIT
  ! VisRunFlag = .FALSE. =>  blocking = 1
  if(visRunFlag) then
    blocking = 0 
  else
    blocking = 1
  endif

  !
  ! Simulations call this function to detect input from the listen socket, client socket, or console
  visitstate = visitdetectinput(blocking, -1)
  ! visitstate <0  Error 
  !             0  Okay - Timed out
  !             1  Listen socket input
  !             2  Engine socket input

  ! Connexion a VisIt
  if (visitstate == 1) then
    visRunFlag = .TRUE.
    visResult = visitattemptconnection()
    if (visResult == 1) then
       write (6,*) 'VisIt connected!'
    else
       write (6,*) 'VisIt did not connect!'
    endif
 
  ! Calcul du nouveau T pour une iteration temporelle 
  elseif (visitstate == 0) then
#endif
  call simulate_one_timestep()

#ifdef USE_VISIT
    ! mise a jour des plot dans VisIt 
    err = visittimestepchanged()
    err = visitupdateplots()

  ! Deconnexion
  elseif (visitstate == 2) then
    visRunFlag =.FALSE.
     if (processvisitcommand() == 0) then
      visResult = visitdisconnect()
      visRunFlag =.TRUE.
    endif

  ! Erreur
  elseif (visitstate < 0) then
    print *, 'visitState < 0 in time stepping loop. Ignoring and continuing'
  endif
#endif
  
  
end do
 
 
end subroutine 
