!> Coprocess result using CATALYST pipeline
!> Calls CXX callbacks
!> - creategriddata -> creategriddata_ in catalyst_callbacks.cxx
!> - addscalarfield -> addscalarfield_ in catalyst_callbacks.cxx
!> - addvectorfield -> addvectorfield_ in catalyst_callbacks.cxx
subroutine result_vtr(x,y,temp,nx,ny,istep,dt)
  implicit none
  
  real*8,  dimension(nx), intent(in) :: x
  real*8,  dimension(ny), intent(in) :: y
  real*8,  dimension(nx,ny), intent(in) :: temp
  integer, intent(in) :: nx
  integer, intent(in) :: ny
  integer, intent(in) :: istep
  real*8, intent(in) :: dt
  
  integer :: i,j
  integer :: flag
  integer :: nz=1
  real*8,  dimension(nx,ny) :: scalar
  real*8 :: t
  
  t = dt*istep
  
  ! Ecriture fichier vtr  
  open(1,file='temps_final.vtr',form = "formatted")
  
  write(1,'(A)') '<VTKFile type="RectilinearGrid" version="0.1" byte_order="LittleEndian">'
  write(1,*) '<RectilinearGrid WholeExtent="',1,nx,1,ny,1,1,'">'
  write(1,*) '<Piece Extent="',1,nx,1,ny,1,1,'">'
  write(1,'(A)') '<PointData>'
  write(1,'(A)') '<DataArray type="Float32" Name="Temp" NumberOfComponents="1" format="ascii">'
  write(1,*)     temp(1:nx,1:ny)
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '</PointData>'
  write(1,'(A)') '<CellData>'
  write(1,'(A)') '</CellData>'
  write(1,'(A)') '<Coordinates>'
  write(1,'(A)') '<DataArray type="Float32" Name="X_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     (x(i),i=1,nx)
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '<DataArray type="Float32" Name="Y_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     (y(i),i=1,ny)
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '<DataArray type="Float32" Name="Z_COORDINATES" NumberOfComponents="1" format="ascii">'
  write(1,*)     0.0
  write(1,'(A)') '</DataArray>'
  write(1,'(A)') '</Coordinates>'
  write(1,'(A)') '</Piece>'
  write(1,'(A)') '</RectilinearGrid>'
  write(1,'(A)') '</VTKFile> '

  close(1)

  ! Ecriture fichier pvd  
  open(2,file='temps_final.pvd',form = "formatted")
  write(2,'(A)') '<VTKFile type="Collection" version="0.1" yte_order="LittleEndian">'
  write(2,'(A)') '<Collection>'
  write(2,*) '<DataSet part="0" timestep="',t,'" file="temps_final.vtr"/>'
  write(2,'(A)') '</Collection>'
  write(2,'(A)') '</VTKFile>'
  close(2)

  return

end subroutine
