subroutine mainloop
USE m_type
implicit none

Integer::nf
Real::ta,td
character(len=64) :: coproc_file       

!calcul du nombre d'itération à effectuer en fonction du type de transfert  
if (typetransfert=='advection') THEN

  tfin=(Larg/(2*U0))

else if (typetransfert=='diffusion') THEN

  tfin=Haut**2/(4*alpha)
  tfin=0.002

else if (typetransfert=='advection-diffusion') THEN

  td=Haut**2/alpha
  ta=(Larg/(U0))
  tfin=max(ta,td)
endif

nf=floor(tfin/dt)
MAXSTEPS=nf
write(*,*) "nombre d'iterations = ", nf
iter=0


#ifdef USE_CATALYST
    coproc_file = "coproc.py"
    if (iargc() == 1) then
      call getarg(1, coproc_file)
    end if
    call coprocessorinitializewithpython(trim(coproc_file), len_trim(coproc_file))
#endif


do while (iter<nf)


if(iter > MAXSTEPS) then
    write(*,*)'Iteration terminated (exceeds ', MAXSTEPS, ')'
    exit                            ! nonconvergent solution
  end if


call simulate_one_timestep()

#ifdef USE_CATALYST
   call result_catalyst(m%xc,m%yc,T,nx1,ny1,iter,dt)
#endif

  
 end do
 
#ifdef USE_CATALYST
    call coprocessorfinalize()
#endif

   call result_vtr(m%xc,m%yc,T,nx1,ny1,iter,dt)

end subroutine 
