!> Coprocess result using CATALYST pipeline
!> Calls CXX callbacks
!> - creategriddata -> creategriddata_ in catalyst_callbacks.cxx
!> - addscalarfield -> addscalarfield_ in catalyst_callbacks.cxx
!> - addvectorfield -> addvectorfield_ in catalyst_callbacks.cxx
subroutine result_catalyst(x,y,temp,nx,ny,istep,dt)
  use iso_c_binding
  implicit none
  
  real*8,  dimension(nx), intent(in) :: x
  real*8,  dimension(ny), intent(in) :: y
  real*8,  dimension(nx,ny), intent(in) :: temp
  integer, intent(in) :: nx
  integer, intent(in) :: ny
  integer, intent(in) :: istep
  real*8, intent(in) :: dt
  
  integer :: i,j
  integer :: flag
  integer :: nz=1
  real*8,  dimension(nx,ny) :: scalar
  real*8 :: t
  
  t = dt*istep
  write(*,*) "CATALYST coprocessing at t=", t
  
  !----------------------------------------------------------------------------
  ! Request for coprocessing flag (flag=1 = coprocessing to be made)
  !----------------------------------------------------------------------------
  call requestdatadescription(istep,t,flag)
  
  if (flag .ne. 0) then
  
    !--------------------------------------------------------------------------
    ! Check if the grid has already been built (flag=1 : grid not built yet)
    !--------------------------------------------------------------------------
    call needtocreategrid(flag)
    if (flag .ne. 0) then
      !------------------------------------------------------------------------
      ! Call grid creation callback (creategriddata_ in catalyst_callbacks.cxx)
      !------------------------------------------------------------------------
      call creategriddata(nx,ny,nz,x,y) ! see catalyst_callbacks.cxx::creategriddata_ 
    end if
    
    !--------------------------------------------------------------------------
    ! Add temperature field
    !--------------------------------------------------------------------------
    do j = 1, ny
      do i = 1, nx
        scalar(i,j) = temp(i,j)
      end do
    end do
    call addscalarfield(scalar,"temp"//char(0))
    
    !--------------------------------------------------------------------------
    ! Do coprocessing
    !--------------------------------------------------------------------------
    call coprocess()

  end if

  return

end subroutine
