SUBROUTINE calcul_advection
USE m_type
IMPLICIT NONE


REAL,DIMENSION(nx-1,ny-1) :: fag,fad,fdg,fdd,fdh,fdb
INTEGER :: i,j


!On fait tous les calculs de flux et de la température pour le cas de l'advection pure
!Seuls les flux advectifs vont influencer la température


DO i=2,nx-2

	DO j=2,ny-2

		fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
		fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)

	END DO
		
END DO



!bord AD
i=1
DO j=2,(ny-2)/2+1

	fag(i,j)=T1*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)

END DO

DO j=(ny-2)/2+2,ny-2

	fag(i,j)=T0*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)

END DO


!bord CD
j=ny-1
DO i=2,nx-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)


END DO



!bord AB
j=1

DO i=2,nx-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)


END DO



!bord BC
i=nx-1
DO j=2,ny-2

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)


END DO




!point A
i=1
j=1

	fag(i,j)=T1*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)




!point B
i=nx-1
j=1

	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)





!point C
i=nx-1
j=ny-1


	fag(i,j)=T(i-1,j)*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i,j)*m%dyn(j)

		
		


!point D
i=1
j=ny-1


	fag(i,j)=T0*U(i,j)*m%dyn(j)
	fad(i,j)=T(i,j)*U(i+1,j)*m%dyn(j)

	
	
	
		
!calcul de la température

DO i=1,nx-1

	DO j=1,ny-1
		
		T(i,j)=T(i,j)+(dt/(m%dxn(i)*m%dyn(j)))*(fag(i,j)-fad(i,j))

	END DO
	
END DO



END SUBROUTINE calcul_advection
