
from paraview.simple import *
from paraview import coprocessing


#--------------------------------------------------------------
# Code generated from cpstate.py to create the CoProcessor.
# ParaView 5.1.0 64 bits


# ----------------------- CoProcessor definition -----------------------

def CreateCoProcessor():
  def _CreatePipeline(coprocessor, datadescription):
    class Pipeline:
      # state file generated using paraview version 5.1.0

      # ----------------------------------------------------------------
      # setup views used in the visualization
      # ----------------------------------------------------------------

      #### disable automatic camera reset on 'Show'
      paraview.simple._DisableFirstRenderCameraReset()

      # Create a new 'Render View'
      renderView2 = CreateView('RenderView')
      renderView2.ViewSize = [851, 603]
      renderView2.AxesGrid = 'GridAxes3DActor'
      renderView2.CenterOfRotation = [0.002500000058716978, 0.00048557504123891704, 0.0]
      renderView2.StereoType = 0
      renderView2.CameraPosition = [0.002729832671391625, 0.00016672204666229535, 0.011694622902150302]
      renderView2.CameraFocalPoint = [0.002729832671391625, 0.00016672204666229535, 0.011437393479090563]
      renderView2.CameraParallelScale = 0.0024902268430878655
      renderView2.Background = [0.32, 0.34, 0.43]

      # register the view with coprocessor
      # and provide it with information such as the filename to use,
      # how frequently to write the images, etc.
      coprocessor.RegisterView(renderView2,
          filename='image_%t.png', freq=10, fittoscreen=0, magnification=1, width=1024, height=768, cinema={})
      renderView2.ViewTime = datadescription.GetTime()

      # ----------------------------------------------------------------
      # setup the data processing pipelines
      # ----------------------------------------------------------------

      # create a new 'PVTrivialProducer'
      # create a producer from a simulation input
      extractinput = coprocessor.CreateProducer(datadescription, 'input')

      # create a new 'Annotate Time Filter'
      annotateTimeFilter1 = AnnotateTimeFilter(Input=extractinput)

      # ----------------------------------------------------------------
      # setup color maps and opacity mapes used in the visualization
      # note: the Get..() functions create a new object, if needed
      # ----------------------------------------------------------------

      # get color transfer function/color map for 'temp'
      tempLUT = GetColorTransferFunction('temp')
      tempLUT.RGBPoints = [28.82923924758891, 0.231373, 0.298039, 0.752941, 40.41461962379445, 0.865003, 0.865003, 0.865003, 52.0, 0.705882, 0.0156863, 0.14902]
      tempLUT.ScalarRangeInitialized = 1.0

      # get opacity transfer function/opacity map for 'temp'
      tempPWF = GetOpacityTransferFunction('temp')
      tempPWF.Points = [28.82923924758891, 0.0, 0.5, 0.0, 52.0, 1.0, 0.5, 0.0]
      tempPWF.ScalarRangeInitialized = 1

      # ----------------------------------------------------------------
      # setup the visualization in view 'renderView2'
      # ----------------------------------------------------------------

      # show data from extractinput
      extractinputDisplay = Show(extractinput, renderView2)
      # trace defaults for the display properties.
      extractinputDisplay.ColorArrayName = ['POINTS', 'temp']
      extractinputDisplay.LookupTable = tempLUT
      extractinputDisplay.OSPRayScaleArray = 'temp'
      extractinputDisplay.OSPRayScaleFunction = 'PiecewiseFunction'
      extractinputDisplay.GlyphType = 'Arrow'
      extractinputDisplay.ScalarOpacityUnitDistance = 0.0004818877445966103

      # show color legend
      extractinputDisplay.SetScalarBarVisibility(renderView2, True)

      # show data from annotateTimeFilter1
      annotateTimeFilter1Display = Show(annotateTimeFilter1, renderView2)

      # setup the color legend parameters for each legend in this view

      # get color legend/bar for tempLUT in view renderView2
      tempLUTColorBar = GetScalarBar(tempLUT, renderView2)
      tempLUTColorBar.Position = [0.8092656642671551, 0.4836895388076491]
      tempLUTColorBar.Position2 = [0.1200000000000001, 0.43000000000000016]
      tempLUTColorBar.Title = 'temp'
      tempLUTColorBar.ComponentTitle = ''

      # ----------------------------------------------------------------
      # finally, restore active source
      SetActiveSource(annotateTimeFilter1)
      # ----------------------------------------------------------------
    return Pipeline()

  class CoProcessor(coprocessing.CoProcessor):
    def CreatePipeline(self, datadescription):
      self.Pipeline = _CreatePipeline(self, datadescription)

  coprocessor = CoProcessor()
  # these are the frequencies at which the coprocessor updates.
  freqs = {'input': [10, 10]}
  coprocessor.SetUpdateFrequencies(freqs)
  return coprocessor

#--------------------------------------------------------------
# Global variables that will hold the pipeline for each timestep
# Creating the CoProcessor object, doesn't actually create the ParaView pipeline.
# It will be automatically setup when coprocessor.UpdateProducers() is called the
# first time.
coprocessor = CreateCoProcessor()

#--------------------------------------------------------------
# Enable Live-Visualizaton with ParaView
coprocessor.EnableLiveVisualization(False, 1)


# ---------------------- Data Selection method ----------------------

def RequestDataDescription(datadescription):
    "Callback to populate the request for current timestep"
    global coprocessor
    if datadescription.GetForceOutput() == True:
        # We are just going to request all fields and meshes from the simulation
        # code/adaptor.
        for i in range(datadescription.GetNumberOfInputDescriptions()):
            datadescription.GetInputDescription(i).AllFieldsOn()
            datadescription.GetInputDescription(i).GenerateMeshOn()
        return

    # setup requests for all inputs based on the requirements of the
    # pipeline.
    coprocessor.LoadRequestedData(datadescription)

# ------------------------ Processing method ------------------------

def DoCoProcessing(datadescription):
    "Callback to do co-processing for current timestep"
    global coprocessor

    # Update the coprocessor by providing it the newly generated simulation data.
    # If the pipeline hasn't been setup yet, this will setup the pipeline.
    coprocessor.UpdateProducers(datadescription)

    # Write output data, if appropriate.
    coprocessor.WriteData(datadescription);

    # Write image capture (Last arg: rescale lookup table), if appropriate.
    coprocessor.WriteImages(datadescription, rescale_lookuptable=False)

    # Live Visualization, if enabled.
    coprocessor.DoLiveVisualization(datadescription, "localhost", 22222)
