/*
	util.c
	Routine de mesures
	Ludovic Sauge
*/

#define __USE_GNU
#define _GNU_SOURCE

#include "util.h"
#include <stdio.h>
#include <stdlib.h>

#ifdef BINDPROCESS
void
bindtocpu(long lcpu)
{
  cpu_set_t mask;

  CPU_ZERO(&mask);
  CPU_SET(lcpu,&mask);
  if(sched_setaffinity(0,sizeof(mask),&mask)!=0) {
          perror( "sched_setaffinity" );
          exit(EXIT_FAILURE);
  } 
}
#endif

double 
dtime()
{
    static int sec = -1;
    struct timeval tv;
    gettimeofday(&tv, (void *)0);
    if (sec < 0) sec = tv.tv_sec;
    double t = (tv.tv_sec - sec) + 1.0e-6*tv.tv_usec;
    return t;
}


#define SERIALIZE() {                                           \
        asm volatile ("xorl %%eax,%%eax":::"eax");              \
        asm volatile ("cpuid":::"eax","ebx","ecx","edx");       \
}

ticks getticks(void)
{
     unsigned a, d; 
     SERIALIZE();
     asm volatile("rdtsc" : "=a" (a), "=d" (d));
     SERIALIZE();
     return ((ticks)a) | (((ticks)d) << 32);
}

double calibrate () {
    double  t0,t1;
    ticks   T0,T1;
    T0=getticks();
    t0=dtime();
    sleep(1);
    t1=dtime();
    T1=getticks();
    return((double)(T1-T0)/(t1-t0)) ;
}

void
banner() 
{
        fprintf(stdout,"building time stamps : %s %s\n",
                        __DATE__,
                        __TIME__);
        fprintf(stdout,"%s",__VERSION__);
#ifdef __GNUC__
        fprintf(stdout,", GNU %d.%d.%d.\n",__GNUC__,__GNUC_MINOR__,__GNUC_PATCHLEVEL__);
#else
        puts(".");
#endif
#if __INTEL_COMPILER  
        fprintf(stdout,"     Using Intel Compiler %d-%d (%s).\n",
                        __INTEL_COMPILER,
                        __INTEL_COMPILER_BUILD_DATE,
                        __VERSION__);
#endif
#ifdef COPT
        fprintf(stdout,"Compil. flags: %s\n",COPT);
#endif

    if(getenv("FREQ")==NULL) { 
            printf("Calibrate reference time..."); fflush(stdout);
            ref = calibrate();
            printf("done.\n") ; fflush(stdout);
            printf("==> estimated processor frequency. %.2f MHz\n",ref*1.e-6);
    } else {
            ref = atof(getenv("FREQ"))*1e6 ;
            printf("==> processor frequency. %.2f MHz\n",ref*1.e-6);
    }
}
