// Ludovic Sauge

#include "util.h"
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#define	REP	1000

#define BUFSIZE 1024

char	filename[1024];
FILE	*fd;

// prevent optimization
void	*noopt;


#ifndef NPAD
#define NPAD 31 
#endif
struct l {
	struct l *n;
	long int pad[NPAD];
}__attribute__((packed));

#define MAXSIZE (1<<22)

int main (int argc, char **argv) 
{
	
	unsigned long long	stride = 0;
	unsigned long long	size = 0;
	unsigned long long	offset = 0;
	unsigned int		res;
	size_t			elemsize ;
	size_t			clsize = 64;
	unsigned int i,j;
	unsigned int rep;
	double r0;

#ifdef BINDPROCESS
	if(argc>1) bindtocpu(atol(argv[1]));
#endif
	banner();
	printf("struct size: %ld bytes\n",elemsize=sizeof(struct l));
	puts("Sizes and distance are expressed in bytes.");

	ticks	T0,T1;
	
	struct l **list;
	struct l *ptr;
	char	 *buffer;

	posix_memalign((void **)&buffer,16,MAXSIZE*sizeof(struct l));

	posix_memalign((void **)&list,16,MAXSIZE*sizeof(struct l*));
	for(i=0;i<MAXSIZE;i++) {
		list[i] = (struct l*)buffer+i;
	}

	puts("");
	puts(" Effective      Array      Dist.  Transfert");
	puts(" Data size (B)  Size (B)   (B)    Timing (CPT)");  
	puts(" -------------- ---------- ------ ------------");

	for(size=512;size<=MAXSIZE;size*=2) {
		for(offset=1;offset<=1;offset*=2)
		{
			// Build the dependency chain
			for(i=0;i<size-offset;i+=offset) {
				list[i]->n = list[i+offset];
			}
			ptr = list[i]->n = list[0];
#if DEBUG
			for(i=0;i<size;i+=offset) {
				printf("%p %p %p %llu\n",
						list[i],list[i]->n,
						list[i]->n-list[i],
						list[i]->n-list[i]
				);
			}
#endif

			{
				T0 = getticks();
				for(i=0;i<(MAXSIZE/32);i++) {
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
					ptr = ptr->n;
				}
				T1 = getticks();
			}
			printf("\t%-10ld %-10ld %-10ld %.1f\t%5llu %d\n",
				size*elemsize/offset,
				size*elemsize,
				offset*elemsize,
				r0=(double)(T1-T0)/(32*i),
				list[0]->n-list[0],
				size/offset
			);
		}
		noopt = ptr;

	}
		free(list);

	return 0;
}


